untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAflDfmF8wTWWI/rtO840mvbOGRmYQI6dVBZiKFJnZysiGpdEnm8YGktc4MfC6LZCcXPdNAyGloxS5W9wokOIoXgc=

OpenBSD 7.5 errata 003, May 10, 2024:

A missing bounds check could lead to a crash due to dereferencing a
zero-sized allocation.

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 003_libcrypto.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install

Index: lib/libcrypto/lhash/lhash.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/lhash/lhash.c,v
diff -u -p -r1.22 lhash.c
--- lib/libcrypto/lhash/lhash.c	2 Mar 2024 11:11:11 -0000	1.22
+++ lib/libcrypto/lhash/lhash.c	6 May 2024 08:22:28 -0000
@@ -294,7 +294,9 @@ doall_util_fn(_LHASH *lh, int use_arg, L
 
 	/* Restore down load factor and trigger contraction. */
 	lh->down_load = down_load;
-	contract(lh);
+	if ((lh->num_nodes > MIN_NODES) &&
+	    (lh->down_load >= (lh->num_items * LH_LOAD_MULT / lh->num_nodes)))
+		contract(lh);
 }
 
 void
