/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildconfiguration.tasks;

import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.internal.buildconfiguration.tasks.DaemonJvmPropertiesUtils;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaLanguageVersion;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.platform.BuildPlatform;

public class DaemonJvmPropertiesAccessor {
    private final Map<String, String> properties;

    public DaemonJvmPropertiesAccessor(Map<String, String> properties) {
        this.properties = properties;
    }

    @Nullable
    public JavaLanguageVersion getVersion() {
        String requestedVersion = this.properties.get("toolchainVersion");
        if (requestedVersion == null) {
            return null;
        }
        try {
            return DefaultJavaLanguageVersion.fromFullVersion((String)requestedVersion);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Value '%s' given for %s is an invalid Java version", requestedVersion, "toolchainVersion"));
        }
    }

    public JvmVendorSpec getVendor() {
        String requestedVendor = this.properties.get("toolchainVendor");
        if (requestedVendor != null) {
            return JvmVendorSpec.of((String)requestedVendor);
        }
        return DefaultJvmVendorSpec.any();
    }

    public boolean getNativeImageCapable() {
        return Boolean.parseBoolean(this.properties.get("toolchainNativeImageCapable"));
    }

    public Map<BuildPlatform, String> getToolchainDownloadUrls() {
        return this.properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("toolchainUrl")).collect(Collectors.toMap(entry -> DaemonJvmPropertiesUtils.getPlatformFromToolchainProperty((String)entry.getKey()), Map.Entry::getValue));
    }
}

