/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.MacroLookup;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.gradle.language.nativeplatform.internal.incremental.TokenLookup;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ComplexExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.SimpleExpression;

public class DefaultSourceIncludesResolver
implements SourceIncludesResolver {
    private static final MissingIncludeFile MISSING_INCLUDE_FILE = new MissingIncludeFile();
    private final FileSystemAccess fileSystemAccess;
    private final Map<File, DirectoryContents> includeRoots = new HashMap<File, DirectoryContents>();
    private final FixedIncludePath includePath;

    public DefaultSourceIncludesResolver(List<File> includePaths, FileSystemAccess fileSystemAccess) {
        this.fileSystemAccess = fileSystemAccess;
        ArrayList<DirectoryContents> includeDirs = new ArrayList<DirectoryContents>(includePaths.size());
        for (File includeDir : includePaths) {
            includeDirs.add(this.toDir(includeDir));
        }
        this.includePath = new FixedIncludePath(includeDirs);
    }

    @Override
    public SourceIncludesResolver.IncludeResolutionResult resolveInclude(File sourceFile, Include include, MacroLookup visibleMacros) {
        BuildableResult results = new BuildableResult();
        this.resolveExpression(visibleMacros, (Expression)include, new PathResolvingVisitor(sourceFile, results), new TokenLookup());
        return results;
    }

    private void resolveExpression(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        if (expression.getType() == IncludeType.SYSTEM) {
            visitor.visitSystem(expression);
        } else if (expression.getType() == IncludeType.QUOTED) {
            visitor.visitQuoted(expression);
        } else if (expression.getType() == IncludeType.IDENTIFIER) {
            visitor.visitIdentifier(expression);
        } else if (expression.getType() == IncludeType.ARGS_LIST) {
            visitor.visitTokens(expression);
        } else {
            if (!visitor.startVisit(expression)) {
                return;
            }
            if (expression.getType() == IncludeType.MACRO) {
                this.resolveMacro(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.MACRO_FUNCTION) {
                this.resolveMacroFunction(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.TOKEN_CONCATENATION) {
                this.resolveTokenConcatenation(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.EXPAND_TOKEN_CONCATENATION) {
                this.resolveAndExpandTokenConcatenation(visibleMacros, expression, visitor, tokenLookup);
            } else if (expression.getType() == IncludeType.EXPRESSIONS) {
                this.resolveExpressionSequence(visibleMacros, expression, visitor, tokenLookup);
            } else {
                visitor.visitUnresolved();
            }
        }
    }

    private void resolveExpressionSequence(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        List expressions = expression.getArguments();
        if (expressions.size() < 2) {
            visitor.visitUnresolved();
            return;
        }
        Expression argListExpression = (Expression)expressions.get(expressions.size() - 1);
        List<Expression> headExpressions = expressions.subList(0, expressions.size() - 1);
        Collection<Expression> args = this.resolveExpressionToTokens(visibleMacros, argListExpression, visitor, tokenLookup);
        for (Expression value : args) {
            this.resolveExpressionSequenceForArgs(visibleMacros, headExpressions, value, visitor, tokenLookup);
        }
    }

    private void resolveExpressionSequenceForArgs(MacroLookup visibleMacros, List<Expression> expressions, Expression args, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        if (args.getType() != IncludeType.ARGS_LIST) {
            visitor.visitUnresolved();
            return;
        }
        Expression macroFunctionExpression = expressions.get(expressions.size() - 1);
        List<Expression> headExpressions = expressions.subList(0, expressions.size() - 1);
        Collection<Expression> identifiers = this.resolveExpressionToTokens(visibleMacros, macroFunctionExpression, visitor, tokenLookup);
        for (Expression value : identifiers) {
            if (value.getType() != IncludeType.IDENTIFIER) {
                visitor.visitUnresolved();
                continue;
            }
            ComplexExpression macroExpression = new ComplexExpression(IncludeType.MACRO_FUNCTION, value.getValue(), args.getArguments());
            if (headExpressions.isEmpty()) {
                this.resolveExpression(visibleMacros, macroExpression, visitor, tokenLookup);
                return;
            }
            Collection<Expression> resolved = this.resolveExpressionToTokens(visibleMacros, macroExpression, visitor, tokenLookup);
            for (Expression newArgs : resolved) {
                this.resolveExpressionSequenceForArgs(visibleMacros, headExpressions, newArgs, visitor, tokenLookup);
            }
        }
    }

    private void resolveTokenConcatenation(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        Collection<Expression> expressions = this.resolveTokenConcatenationToTokens(visibleMacros, expression, visitor, tokenLookup);
        for (Expression concatExpression : expressions) {
            this.resolveExpression(visibleMacros, concatExpression, visitor, tokenLookup);
        }
    }

    private void resolveAndExpandTokenConcatenation(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        Collection<Expression> expressions = this.resolveTokenConcatenationToTokens(visibleMacros, expression, visitor, tokenLookup);
        for (Expression concatExpression : expressions) {
            this.resolveExpression(visibleMacros, concatExpression.asMacroExpansion(), visitor, tokenLookup);
        }
    }

    private Collection<Expression> resolveExpressionToTokens(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        if (expression.getType() == IncludeType.TOKEN_CONCATENATION) {
            return this.resolveTokenConcatenationToTokens(visibleMacros, expression, visitor, tokenLookup);
        }
        if (expression.getType() != IncludeType.MACRO && expression.getType() != IncludeType.MACRO_FUNCTION && expression.getType() != IncludeType.EXPAND_TOKEN_CONCATENATION) {
            return Collections.singletonList(expression);
        }
        if (!tokenLookup.hasTokensFor(expression)) {
            this.resolveExpression(visibleMacros, expression, new CollectTokens(tokenLookup, expression), tokenLookup);
        }
        if (tokenLookup.isUnresolved(expression)) {
            visitor.visitUnresolved();
        }
        return tokenLookup.tokensFor(expression);
    }

    private Collection<Expression> resolveTokenConcatenationToTokens(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        Expression left = (Expression)expression.getArguments().get(0);
        Expression right = (Expression)expression.getArguments().get(1);
        Collection<Expression> leftValues = this.resolveExpressionToTokens(visibleMacros, left, visitor, tokenLookup);
        Collection<Expression> rightValues = this.resolveExpressionToTokens(visibleMacros, right, visitor, tokenLookup);
        if (leftValues.isEmpty() || rightValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>(leftValues.size() * rightValues.size());
        for (Expression leftValue : leftValues) {
            if (leftValue.getType() != IncludeType.IDENTIFIER) {
                Expression rightValue;
                if (rightValues.size() == 1 && (rightValue = rightValues.iterator().next()).getType() == IncludeType.EXPRESSIONS && rightValue.getArguments().isEmpty()) {
                    expressions.add(leftValue);
                    continue;
                }
                visitor.visitUnresolved();
                continue;
            }
            String leftString = leftValue.getValue();
            for (Expression rightValue : rightValues) {
                if (rightValue.getType() == IncludeType.IDENTIFIER) {
                    expressions.add(new SimpleExpression(leftString + rightValue.getValue(), IncludeType.IDENTIFIER));
                    continue;
                }
                if (rightValue.getType() == IncludeType.ARGS_LIST) {
                    expressions.add(new ComplexExpression(IncludeType.MACRO_FUNCTION, leftString, rightValue.getArguments()));
                    continue;
                }
                if (rightValue.getType() == IncludeType.EXPRESSIONS && rightValue.getArguments().isEmpty()) {
                    expressions.add(new SimpleExpression(leftString, IncludeType.IDENTIFIER));
                    continue;
                }
                visitor.visitUnresolved();
            }
        }
        return expressions;
    }

    private void resolveMacro(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        boolean found = false;
        for (IncludeDirectives includeDirectives : visibleMacros) {
            Iterable macros = includeDirectives.getMacros(expression.getValue());
            for (Macro macro : macros) {
                found = true;
                this.resolveExpression(visibleMacros, (Expression)macro, visitor, tokenLookup);
            }
        }
        if (!found) {
            visitor.visitIdentifier(new SimpleExpression(expression.getValue(), IncludeType.IDENTIFIER));
        }
    }

    private void resolveMacroFunction(MacroLookup visibleMacros, Expression expression, ExpressionVisitor visitor, TokenLookup tokenLookup) {
        boolean found = false;
        for (IncludeDirectives includeDirectives : visibleMacros) {
            Iterable macroFunctions = includeDirectives.getMacroFunctions(expression.getValue());
            for (MacroFunction macro : macroFunctions) {
                List<Expression> arguments = expression.getArguments();
                if (arguments.isEmpty() && macro.getParameterCount() == 1) {
                    arguments = Collections.singletonList(SimpleExpression.EMPTY_EXPRESSIONS);
                }
                if (macro.getParameterCount() != arguments.size()) continue;
                found = true;
                Expression result = macro.evaluate(arguments);
                this.resolveExpression(visibleMacros, result, visitor, tokenLookup);
            }
        }
        if (!found) {
            visitor.visitUnresolved();
        }
    }

    @Override
    @Nullable
    public SourceIncludesResolver.IncludeFile resolveInclude(@Nullable File sourceFile, String includePath) {
        FixedIncludePath path = sourceFile != null ? this.prependSourceDir(sourceFile, this.includePath) : this.includePath;
        return ((IncludePath)path).searchForDependency(includePath, sourceFile != null);
    }

    private DirectoryContents toDir(File includeDir) {
        DirectoryContents directoryContents = this.includeRoots.get(includeDir);
        if (directoryContents == null) {
            directoryContents = new DirectoryContents(includeDir);
            this.includeRoots.put(includeDir, directoryContents);
        }
        return directoryContents;
    }

    private IncludePath prependSourceDir(File sourceFile, FixedIncludePath includePaths) {
        File sourceDir = sourceFile.getParentFile();
        if (includePaths.startsWith(sourceDir)) {
            return includePaths;
        }
        return new PrefixedIncludePath(this.toDir(sourceDir), includePaths);
    }

    private File normalizeIncludePath(File searchDir, String prefixPath) {
        boolean onlyDotsSinceLastSeparator = true;
        for (int i = 0; i < prefixPath.length(); ++i) {
            char currentChar = prefixPath.charAt(i);
            if (currentChar == '/' || currentChar == '\\') {
                if (onlyDotsSinceLastSeparator) {
                    return FileUtils.normalize((File)new File(searchDir, prefixPath));
                }
                onlyDotsSinceLastSeparator = true;
                continue;
            }
            if (currentChar == '.') continue;
            onlyDotsSinceLastSeparator = false;
        }
        return new File(searchDir, prefixPath);
    }

    private static class FixedIncludePath
    extends IncludePath {
        private final List<DirectoryContents> directories;
        private final Map<String, CachedIncludeFile> cachedLookups = new HashMap<String, CachedIncludeFile>();

        FixedIncludePath(List<DirectoryContents> directories) {
            this.directories = directories;
        }

        @Override
        @Nullable
        SourceIncludesResolver.IncludeFile searchForDependency(String includePath, boolean quotedPath) {
            CachedIncludeFile includeFile = this.cachedLookups.get(includePath);
            if (includeFile == null) {
                DirectoryContents dir;
                Iterator<DirectoryContents> iterator = this.directories.iterator();
                while (iterator.hasNext() && (includeFile = (dir = iterator.next()).get(includePath)).getType() != FileType.RegularFile) {
                }
                if (includeFile == null) {
                    includeFile = MISSING_INCLUDE_FILE;
                }
                this.cachedLookups.put(includePath, includeFile);
            }
            if (includeFile.getType() == FileType.RegularFile) {
                return includeFile.toIncludeFile(quotedPath);
            }
            return null;
        }

        public boolean startsWith(File sourceDir) {
            return this.directories.size() > 0 && this.directories.get(0).searchDir.equals(sourceDir);
        }
    }

    private static abstract class IncludePath {
        private IncludePath() {
        }

        @Nullable
        abstract SourceIncludesResolver.IncludeFile searchForDependency(String var1, boolean var2);
    }

    private static class MissingIncludeFile
    extends CachedIncludeFile {
        MissingIncludeFile() {
        }

        @Override
        FileType getType() {
            return FileType.Missing;
        }

        @Override
        SourceIncludesResolver.IncludeFile toIncludeFile(boolean quotedPath) {
            throw new UnsupportedOperationException();
        }
    }

    private class DirectoryContents {
        private final File searchDir;
        private final Map<String, CachedIncludeFile> contents = new HashMap<String, CachedIncludeFile>();

        DirectoryContents(File searchDir) {
            this.searchDir = searchDir;
        }

        CachedIncludeFile get(String includePath) {
            return this.contents.computeIfAbsent(includePath, key -> {
                File candidate = DefaultSourceIncludesResolver.this.normalizeIncludePath(this.searchDir, includePath);
                return DefaultSourceIncludesResolver.this.fileSystemAccess.readRegularFileContentHash(candidate.getAbsolutePath()).map(contentHash -> new SystemIncludeFile(candidate, (String)key, (HashCode)contentHash)).orElse(MISSING_INCLUDE_FILE);
            });
        }
    }

    private static class BuildableResult
    implements SourceIncludesResolver.IncludeResolutionResult {
        private final Set<SourceIncludesResolver.IncludeFile> files = new LinkedHashSet<SourceIncludesResolver.IncludeFile>();
        private boolean missing;

        private BuildableResult() {
        }

        void resolved(SourceIncludesResolver.IncludeFile includeFile) {
            this.files.add(includeFile);
        }

        void unresolved() {
            this.missing = true;
        }

        @Override
        public boolean isComplete() {
            return !this.missing;
        }

        public Set<SourceIncludesResolver.IncludeFile> getFiles() {
            return this.files;
        }
    }

    private class PathResolvingVisitor
    implements ExpressionVisitor {
        private final File sourceFile;
        private final BuildableResult results;
        private final Set<Expression> seen = new HashSet<Expression>();
        Set<String> quoted = new HashSet<String>();
        Set<String> system = new HashSet<String>();

        PathResolvingVisitor(File sourceFile, BuildableResult results) {
            this.sourceFile = sourceFile;
            this.results = results;
        }

        @Override
        public boolean startVisit(Expression expression) {
            return this.seen.add(expression);
        }

        @Override
        public void visitQuoted(Expression value) {
            String path = value.getValue();
            if (!this.quoted.add(path)) {
                return;
            }
            IncludePath quotedSearchPath = DefaultSourceIncludesResolver.this.prependSourceDir(this.sourceFile, DefaultSourceIncludesResolver.this.includePath);
            SourceIncludesResolver.IncludeFile includeFile = quotedSearchPath.searchForDependency(path, true);
            if (includeFile != null) {
                this.results.resolved(includeFile);
            }
        }

        @Override
        public void visitSystem(Expression value) {
            String path = value.getValue();
            if (!this.system.add(path)) {
                return;
            }
            SourceIncludesResolver.IncludeFile includeFile = DefaultSourceIncludesResolver.this.includePath.searchForDependency(path, false);
            if (includeFile != null) {
                this.results.resolved(includeFile);
            }
        }

        @Override
        public void visitIdentifier(Expression value) {
            this.results.unresolved();
        }

        @Override
        public void visitTokens(Expression tokens) {
            this.results.unresolved();
        }

        @Override
        public void visitUnresolved() {
            this.results.unresolved();
        }
    }

    private static interface ExpressionVisitor {
        public boolean startVisit(Expression var1);

        public void visitQuoted(Expression var1);

        public void visitSystem(Expression var1);

        public void visitIdentifier(Expression var1);

        public void visitTokens(Expression var1);

        public void visitUnresolved();
    }

    private static class CollectTokens
    implements ExpressionVisitor {
        private final Set<Expression> seen = new HashSet<Expression>();
        private final TokenLookup tokenLookup;
        private final Expression expression;

        CollectTokens(TokenLookup tokenLookup, Expression expression) {
            this.tokenLookup = tokenLookup;
            this.expression = expression;
        }

        @Override
        public boolean startVisit(Expression expression) {
            return this.seen.add(expression);
        }

        @Override
        public void visitQuoted(Expression value) {
            this.visitTokens(value);
        }

        @Override
        public void visitSystem(Expression value) {
            this.visitTokens(value);
        }

        @Override
        public void visitIdentifier(Expression value) {
            this.visitTokens(value);
        }

        @Override
        public void visitTokens(Expression tokens) {
            this.tokenLookup.addTokensFor(this.expression, tokens);
        }

        @Override
        public void visitUnresolved() {
            this.tokenLookup.unresolved(this.expression);
        }
    }

    private static class PrefixedIncludePath
    extends IncludePath {
        private final DirectoryContents head;
        private final IncludePath tail;

        PrefixedIncludePath(DirectoryContents head, IncludePath tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        @Nullable
        SourceIncludesResolver.IncludeFile searchForDependency(String includePath, boolean quotedPath) {
            CachedIncludeFile includeFile = this.head.get(includePath);
            if (includeFile.getType() == FileType.RegularFile) {
                return includeFile.toIncludeFile(quotedPath);
            }
            return this.tail.searchForDependency(includePath, quotedPath);
        }
    }

    private static class SystemIncludeFile
    extends CachedIncludeFile
    implements SourceIncludesResolver.IncludeFile {
        final File file;
        final String includePath;
        final HashCode contentHash;

        SystemIncludeFile(File file, String includePath, HashCode contentHash) {
            this.file = file;
            this.includePath = includePath;
            this.contentHash = contentHash;
        }

        @Override
        public String getPath() {
            return this.includePath;
        }

        @Override
        public boolean isQuotedInclude() {
            return false;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        FileType getType() {
            return FileType.RegularFile;
        }

        @Override
        public HashCode getContentHash() {
            return this.contentHash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SystemIncludeFile other = (SystemIncludeFile)obj;
            return Objects.equal((Object)this.file, (Object)other.file) && this.contentHash.equals((Object)other.contentHash);
        }

        public int hashCode() {
            return this.contentHash.hashCode();
        }

        @Override
        SourceIncludesResolver.IncludeFile toIncludeFile(boolean quotedPath) {
            if (quotedPath) {
                return new QuotedIncludeFile(this.file, this.includePath, this.contentHash);
            }
            return this;
        }

        private static class QuotedIncludeFile
        extends SystemIncludeFile {
            QuotedIncludeFile(File file, String includePath, HashCode contentHash) {
                super(file, includePath, contentHash);
            }

            @Override
            public boolean isQuotedInclude() {
                return true;
            }
        }
    }

    private static abstract class CachedIncludeFile {
        private CachedIncludeFile() {
        }

        abstract FileType getType();

        abstract SourceIncludesResolver.IncludeFile toIncludeFile(boolean var1);
    }
}

