/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.redirector;

import java.io.PrintStream;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.redirector.StandardOutputRedirector;
import org.gradle.internal.io.LinePerThreadBufferingOutputStream;
import org.gradle.internal.io.TextStream;

public class DefaultStandardOutputRedirector
implements StandardOutputRedirector {
    private PrintStream originalStdOut;
    private PrintStream originalStdErr;
    private final WriteAction stdOut = new WriteAction();
    private final WriteAction stdErr = new WriteAction();
    private final PrintStream redirectedStdOut = new LinePerThreadBufferingOutputStream((TextStream)this.stdOut);
    private final PrintStream redirectedStdErr = new LinePerThreadBufferingOutputStream((TextStream)this.stdErr);

    @Override
    public void redirectStandardOutputTo(StandardOutputRedirector.OutputListener stdOutDestination) {
        this.stdOut.setDestination(stdOutDestination);
    }

    @Override
    public void redirectStandardErrorTo(StandardOutputRedirector.OutputListener stdErrDestination) {
        this.stdErr.setDestination(stdErrDestination);
    }

    @Override
    public void start() {
        if (this.stdOut.destination != null) {
            this.originalStdOut = System.out;
            System.setOut(this.redirectedStdOut);
        }
        if (this.stdErr.destination != null) {
            this.originalStdErr = System.err;
            System.setErr(this.redirectedStdErr);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.originalStdOut != null) {
                System.setOut(this.originalStdOut);
            }
            if (this.originalStdErr != null) {
                System.setErr(this.originalStdErr);
            }
            this.redirectedStdOut.flush();
            this.redirectedStdErr.flush();
        }
        finally {
            this.originalStdOut = null;
            this.originalStdErr = null;
            this.stdOut.setDestination(new DiscardAction());
            this.stdErr.setDestination(new DiscardAction());
        }
    }

    private static class WriteAction
    implements TextStream {
        private StandardOutputRedirector.OutputListener destination;

        private WriteAction() {
        }

        public void text(String message) {
            this.destination.onOutput(message);
        }

        public void endOfStream(@Nullable Throwable failure) {
        }

        public void setDestination(StandardOutputRedirector.OutputListener destination) {
            this.destination = destination;
        }
    }

    private static class DiscardAction
    implements StandardOutputRedirector.OutputListener {
        private DiscardAction() {
        }

        @Override
        public void onOutput(CharSequence output) {
        }
    }
}

