/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateRequestParser
extends HandshakeMessageParser<CertificateRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateRequestParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.CERTIFICATE_REQUEST, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(CertificateRequestMessage msg) {
        LOGGER.debug("Parsing CertificateRequestMessage");
        if (this.getVersion().isTLS13()) {
            this.parseCertificateRequestContextLength(msg);
            this.parseCertificateRequestContext(msg);
            this.parseExtensionLength(msg);
            this.parseExtensionBytes(msg);
        } else {
            this.parseClientCertificateTypesCount(msg);
            this.parseClientCertificateTypes(msg);
            if (this.getVersion() == ProtocolVersion.TLS12 || this.getVersion() == ProtocolVersion.DTLS12) {
                this.parseSignatureHashAlgorithmsLength(msg);
                this.parseSignatureHashAlgorithms(msg);
            }
            this.parseDistinguishedNamesLength(msg);
            if (this.hasDistinguishedNamesLength(msg)) {
                this.parseDistinguishedNames(msg);
            }
        }
    }

    @Override
    protected CertificateRequestMessage createHandshakeMessage() {
        return new CertificateRequestMessage();
    }

    private void parseClientCertificateTypesCount(CertificateRequestMessage msg) {
        msg.setClientCertificateTypesCount(this.parseIntField(1));
        LOGGER.debug("ClientCertificateTypesCount: " + msg.getClientCertificateTypesCount().getValue());
    }

    private void parseClientCertificateTypes(CertificateRequestMessage msg) {
        msg.setClientCertificateTypes(this.parseByteArrayField((Integer)msg.getClientCertificateTypesCount().getValue()));
        LOGGER.debug("ClientCertificateTypes: " + Arrays.toString((byte[])msg.getClientCertificateTypes().getValue()));
    }

    private void parseSignatureHashAlgorithmsLength(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithmsLength(this.parseIntField(2));
        LOGGER.debug("SignatureHashAlgorithmsLength: " + msg.getSignatureHashAlgorithmsLength().getValue());
    }

    private void parseSignatureHashAlgorithms(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithms(this.parseByteArrayField((Integer)msg.getSignatureHashAlgorithmsLength().getValue()));
        LOGGER.debug("SignatureHashAlgorithms: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureHashAlgorithms().getValue())));
    }

    private void parseDistinguishedNamesLength(CertificateRequestMessage msg) {
        msg.setDistinguishedNamesLength(this.parseIntField(2));
        LOGGER.debug("DistinguishedNamesLength: " + msg.getDistinguishedNamesLength().getValue());
    }

    private boolean hasDistinguishedNamesLength(CertificateRequestMessage msg) {
        return (Integer)msg.getDistinguishedNamesLength().getValue() != 0;
    }

    private void parseDistinguishedNames(CertificateRequestMessage msg) {
        msg.setDistinguishedNames(this.parseByteArrayField((Integer)msg.getDistinguishedNamesLength().getValue()));
        LOGGER.debug("DistinguishedNames: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getDistinguishedNames().getValue())));
    }

    private void parseCertificateRequestContextLength(CertificateRequestMessage msg) {
        msg.setCertificateRequestContextLength(this.parseIntField(1));
        LOGGER.debug("CertificateRequestContextLength: " + msg.getCertificateRequestContextLength().getValue());
    }

    private void parseCertificateRequestContext(CertificateRequestMessage msg) {
        msg.setCertificateRequestContext(this.parseByteArrayField((Integer)msg.getCertificateRequestContextLength().getValue()));
        LOGGER.debug("CertificateRequestContext: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCertificateRequestContext().getValue())));
    }
}

