/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;

public class LightReferenceListBuilder
extends LightElement
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private volatile PsiClassType[] myCachedTypes;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public LightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, JavaLanguage.INSTANCE, role);
    }

    public LightReferenceListBuilder(PsiManager manager, Language language2, PsiReferenceList.Role role) {
        super(manager, language2);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory(this.getProject());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "light reference list";
    }

    public void addReference(PsiClass aClass) {
        this.addReference(aClass.getQualifiedName());
    }

    public void addReference(String qualifiedName) {
        this.myRefs.add(this.myFactory.createReferenceElementByFQClassName(qualifiedName, this.getResolveScope()));
    }

    public void addReference(PsiClassType type2) {
        this.myRefs.add(this.myFactory.createReferenceElementByType(type2));
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = this.myRefs.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
        if (psiJavaCodeReferenceElementArray == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(1);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public PsiClassType @NotNull [] getReferencedTypes() {
        PsiClassType[] types2 = this.myCachedTypes;
        if (types2 == null) {
            int size = this.myRefs.size();
            types2 = size == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[size];
            for (int i = 0; i < size; ++i) {
                types2[i] = this.myFactory.createType(this.myRefs.get(i));
            }
            this.myCachedTypes = types2;
        }
        if (types2 == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(2);
        }
        return types2;
    }

    @Override
    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightReferenceListBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightReferenceListBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

