/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.clonerow;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.clonerow.CloneRow;
import org.pentaho.di.trans.steps.clonerow.CloneRowData;
import org.pentaho.di.trans.steps.clonerow.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneRowMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String nrclones;
    private boolean addcloneflag;
    private String cloneflagfield;
    private boolean nrcloneinfield;
    private String nrclonefield;

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"nrclones", (String)this.nrclones));
        retval.append("    " + XMLHandler.addTagValue((String)"addcloneflag", (boolean)this.addcloneflag));
        retval.append("    " + XMLHandler.addTagValue((String)"cloneflagfield", (String)this.cloneflagfield));
        retval.append("    " + XMLHandler.addTagValue((String)"nrcloneinfield", (boolean)this.nrcloneinfield));
        retval.append("    " + XMLHandler.addTagValue((String)"nrclonefield", (String)this.nrclonefield));
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getNrClones() {
        return this.nrclones;
    }

    public void setNrClones(String nrclones) {
        this.nrclones = nrclones;
    }

    public boolean isAddCloneFlag() {
        return this.addcloneflag;
    }

    public void setAddCloneFlag(boolean addcloneflag) {
        this.addcloneflag = addcloneflag;
    }

    public boolean isNrCloneInField() {
        return this.nrcloneinfield;
    }

    public void setNrCloneInField(boolean nrcloneinfield) {
        this.nrcloneinfield = nrcloneinfield;
    }

    public String getNrCloneField() {
        return this.nrclonefield;
    }

    public void setNrCloneField(String nrclonefield) {
        this.nrclonefield = nrclonefield;
    }

    public String getCloneFlagField() {
        return this.cloneflagfield;
    }

    public void setCloneFlagField(String cloneflagfield) {
        this.cloneflagfield = cloneflagfield;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.nrclones = XMLHandler.getTagValue((Node)stepnode, (String)"nrclones");
            this.addcloneflag = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addcloneflag"));
            this.cloneflagfield = XMLHandler.getTagValue((Node)stepnode, (String)"cloneflagfield");
            this.nrcloneinfield = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"nrcloneinfield"));
            this.nrclonefield = XMLHandler.getTagValue((Node)stepnode, (String)"nrclonefield");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("CloneRowMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.nrclones = "0";
        this.cloneflagfield = null;
        this.nrclonefield = null;
        this.nrcloneinfield = false;
        this.addcloneflag = false;
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.nrclones = rep.getStepAttributeString(id_step, "nrclones");
            this.addcloneflag = rep.getStepAttributeBoolean(id_step, "addcloneflag");
            this.cloneflagfield = rep.getStepAttributeString(id_step, "cloneflagfield");
            this.nrcloneinfield = rep.getStepAttributeBoolean(id_step, "nrcloneinfield");
            this.nrclonefield = rep.getStepAttributeString(id_step, "nrclonefield");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("CloneRowMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "nrclones", this.nrclones);
            rep.saveStepAttribute(id_transformation, id_step, "addcloneflag", this.addcloneflag);
            rep.saveStepAttribute(id_transformation, id_step, "cloneflagfield", this.cloneflagfield);
            rep.saveStepAttribute(id_transformation, id_step, "nrcloneinfield", this.nrcloneinfield);
            rep.saveStepAttribute(id_transformation, id_step, "nrclonefield", this.nrclonefield);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("CloneRowMeta.Exception.UnexpectedErrorSavingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (this.addcloneflag && !Const.isEmpty((String)this.cloneflagfield)) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.cloneflagfield), 4);
            v.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.nrclones)) {
            error_message = Messages.getString("CloneRowMeta.CheckResult.NrClonesdMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
        } else {
            error_message = Messages.getString("CloneRowMeta.CheckResult.NrClonesOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
        }
        remarks.add((CheckResultInterface)cr);
        if (this.addcloneflag) {
            if (Const.isEmpty((String)this.cloneflagfield)) {
                error_message = Messages.getString("CloneRowMeta.CheckResult.CloneFlagFieldMissing");
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            } else {
                error_message = Messages.getString("CloneRowMeta.CheckResult.CloneFlagFieldOk");
                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
            }
            remarks.add((CheckResultInterface)cr);
        }
        if (this.nrcloneinfield) {
            if (Const.isEmpty((String)this.nrclonefield)) {
                error_message = Messages.getString("CloneRowMeta.CheckResult.NrCloneFieldMissing");
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            } else {
                error_message = Messages.getString("CloneRowMeta.CheckResult.NrCloneFieldOk");
                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepinfo);
            }
            remarks.add((CheckResultInterface)cr);
        }
        cr = prev == null || prev.size() == 0 ? new CheckResult(3, Messages.getString("CloneRowMeta.CheckResult.NotReceivingFields"), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("CloneRowMeta.CheckResult.StepRecevingData", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, Messages.getString("CloneRowMeta.CheckResult.StepRecevingData2"), (CheckResultSourceInterface)stepinfo) : new CheckResult(4, Messages.getString("CloneRowMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CloneRow(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CloneRowData();
    }
}

