/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import com.microsoft.sqlserver.jdbc.StreamError;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ListResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerException
extends SQLException
implements Serializable {
    static final String EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH = "08001";
    static final String EXCEPTION_XOPEN_CONNECTION_FAILURE = "08006";
    static final int LOGON_FAILED = 18456;
    static final int PASSWORD_EXPIRED = 18488;
    private final StreamError streamError;
    static Logger exLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerException");

    final StreamError getDatabaseError() {
        return this.streamError;
    }

    private void logException(IOBuffer iOBuffer, String string, boolean bl) {
        String string2 = "";
        if (iOBuffer != null) {
            string2 = iOBuffer.instanceId();
        }
        if (exLogger.isLoggable(Level.FINE)) {
            exLogger.fine("*** SQLException:" + string2 + " " + this.toString() + " " + string);
        }
        if (bl && exLogger.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer(100);
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append(stackTraceElementArray[i].toString());
            }
            exLogger.fine(stringBuffer.toString());
        }
    }

    static String getErrString(String string) {
        ListResourceBundle listResourceBundle = (ListResourceBundle)SQLServerResource.getBundle("com.microsoft.sqlserver.jdbc.SQLServerResource");
        return listResourceBundle.getString(string);
    }

    public SQLServerException(IOBuffer iOBuffer, String string, String string2, int n, boolean bl) {
        super(string, string2, n);
        this.streamError = null;
        this.logException(iOBuffer, string, bl);
    }

    public SQLServerException(IOBuffer iOBuffer, String string, String string2, StreamError streamError, boolean bl) {
        super(string, string2, streamError.getErrorNumber());
        this.streamError = streamError;
        string = "Msg " + streamError.getErrorNumber() + ", Level " + streamError.getErrorSeverity() + ", State " + streamError.getErrorState() + ", " + string;
        this.logException(iOBuffer, string, bl);
    }

    public static void makeFromDriverError(SQLServerConnection sQLServerConnection, IOBuffer iOBuffer, String string, String string2, boolean bl) throws SQLServerException {
        String string3 = "";
        if (null != string2 && string2.equals(EXCEPTION_XOPEN_CONNECTION_FAILURE) && null != sQLServerConnection) {
            sQLServerConnection.close();
        }
        if (string2 != null) {
            string3 = string2;
        }
        if (sQLServerConnection == null || !sQLServerConnection.xopenStates) {
            string3 = SQLServerException.mapFromXopen(string2);
        }
        throw new SQLServerException(iOBuffer, string, string3, 0, bl);
    }

    public static void makeFromDatabaseError(SQLServerConnection sQLServerConnection, IOBuffer iOBuffer, String string, StreamError streamError, boolean bl) throws SQLServerException {
        String string2 = SQLServerException.generateStateCode(sQLServerConnection, streamError.getErrorNumber(), streamError.getErrorState());
        if (streamError.getErrorSeverity() >= 20 && null != sQLServerConnection) {
            sQLServerConnection.close();
        }
        throw new SQLServerException(iOBuffer, string, string2, streamError, bl);
    }

    public static String mapFromXopen(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("07009")) {
            return "S1093";
        }
        if (string.equals(EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH)) {
            return "08S01";
        }
        if (string.equals(EXCEPTION_XOPEN_CONNECTION_FAILURE)) {
            return "08S01";
        }
        return "";
    }

    public static String generateStateCode(SQLServerConnection sQLServerConnection, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = sQLServerConnection != null && sQLServerConnection.xopenStates;
        if (bl) {
            switch (n) {
                case 4060: {
                    return EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH;
                }
                case 18456: {
                    return EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH;
                }
                case 2714: {
                    return "42S01";
                }
                case 208: {
                    return "42S02";
                }
                case 207: {
                    return "42S22";
                }
            }
            return "42000";
        }
        switch (n) {
            case 8152: {
                return "22001";
            }
            case 515: 
            case 547: {
                return "23000";
            }
            case 2714: {
                return "S0001";
            }
            case 208: {
                return "S0002";
            }
            case 1205: {
                return "40001";
            }
            case 2627: {
                return "23000";
            }
        }
        return "S000" + n2;
    }

    int getSQLSeverity() {
        if (null != this.streamError) {
            return this.streamError.getErrorSeverity();
        }
        return 0;
    }
}

