/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import java.io.Serializable;
import java.util.Comparator;
import org.carrot2.text.preprocessing.Substring;

class SubstringComparator
implements Comparator<Substring>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] tokensWordIndex;
    private final int[] wordsStemIndex;

    public SubstringComparator(int[] tokensWordIndex, int[] wordsStemIndex) {
        this.tokensWordIndex = tokensWordIndex;
        this.wordsStemIndex = wordsStemIndex;
    }

    @Override
    public int compare(Substring s1, Substring s2) {
        int s1To = s1.to;
        int s1From = s1.from;
        int s1Length = s1To - s1From;
        int s2To = s2.to;
        int s2From = s2.from;
        int s2Length = s2To - s2From;
        if (s1Length != s2Length) {
            return s1Length - s2Length;
        }
        assert (s1Length == s2Length);
        for (int i = 0; i < s1Length; ++i) {
            int stemIndex1 = this.wordsStemIndex[this.tokensWordIndex[s1From + i]];
            int stemIndex2 = this.wordsStemIndex[this.tokensWordIndex[s2From + i]];
            if (stemIndex1 == stemIndex2) continue;
            return stemIndex1 - stemIndex2;
        }
        return 0;
    }
}

