/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.ObjectFloatAssociativeContainer;
import com.carrotsearch.hppc.ObjectFloatHashMap;

public class ObjectFloatIdentityHashMap<KType>
extends ObjectFloatHashMap<KType> {
    public ObjectFloatIdentityHashMap() {
        this(4);
    }

    public ObjectFloatIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectFloatIdentityHashMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectFloatIdentityHashMap(ObjectFloatAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mixPhi(System.identityHashCode(key));
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectFloatIdentityHashMap<KType> from(KType[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectFloatIdentityHashMap<KType> map = new ObjectFloatIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

