/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.pert;

import com.projectlibre1.pm.graphic.model.cache.GraphicDependency;
import com.projectlibre1.pm.graphic.model.cache.GraphicNode;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DependencyGraph {
    protected HashMap nodeMap = new HashMap();
    protected NodeModelCache cache;

    public void setCache(NodeModelCache nodeModelCache) {
        this.cache = nodeModelCache;
        this.nodeMap.clear();
    }

    public void insertDependency(GraphicDependency graphicDependency) {
        Node node;
        GraphicNode graphicNode = graphicDependency.getPredecessor();
        GraphicNode graphicNode2 = graphicDependency.getSuccessor();
        Node node2 = (Node)this.nodeMap.get(graphicNode);
        if (node2 == null) {
            node2 = new Node(graphicNode);
            this.nodeMap.put(graphicNode, node2);
        }
        if ((node = (Node)this.nodeMap.get(graphicNode2)) == null) {
            node = new Node(graphicNode2);
            this.nodeMap.put(graphicNode2, node);
        }
        node2.addSuccessor(node);
        node.addPredecessor(node2);
    }

    public void removeDependency(GraphicDependency graphicDependency) {
        GraphicNode graphicNode = graphicDependency.getPredecessor();
        GraphicNode graphicNode2 = graphicDependency.getSuccessor();
        Node node = (Node)this.nodeMap.get(graphicNode);
        Node node2 = (Node)this.nodeMap.get(graphicNode2);
        if (node == null || node2 == null) {
            return;
        }
        node.removeSuccessor(node2);
        node2.removePredecessor(node);
        if (node.isolated()) {
            this.nodeMap.remove(node.getValue());
        }
        if (node2.isolated()) {
            this.nodeMap.remove(node2.getValue());
        }
    }

    public void insertDependencies(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.insertDependency((GraphicDependency)iterator.next());
        }
    }

    public void removeDependencies(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.removeDependency((GraphicDependency)iterator.next());
        }
    }

    public void updatePertLevels() {
        HashSet<Node> hashSet = this.cache.getIterator();
        while (hashSet.hasNext()) {
            this.resetCachePertLevel((GraphicNode)hashSet.next());
        }
        hashSet = new HashSet();
        Object object = new HashSet<Node>();
        for (Node node : this.nodeMap.values()) {
            GraphicNode graphicNode = (GraphicNode)node.getValue();
            if (node.getPredecessors().size() != 0) continue;
            hashSet.add(node);
        }
        while (hashSet.size() > 0) {
            this.updateSuccessorsPertLevel(hashSet, (Set)object);
            HashSet<Node> hashSet2 = hashSet;
            hashSet = object;
            object = hashSet2;
            object.clear();
        }
    }

    private void updateSuccessorsPertLevel(Set set, Set set2) {
        for (Node node : set) {
            GraphicNode graphicNode = (GraphicNode)node.getValue();
            for (Node node2 : node.getSuccessors()) {
                set2.add(node2);
                GraphicNode graphicNode2 = (GraphicNode)node2.getValue();
                this.correctPertLevel(graphicNode, graphicNode2);
            }
        }
    }

    private void resetCachePertLevel(GraphicNode graphicNode) {
        this.cache.setPertLevel(graphicNode, this.cache.getLevel(graphicNode));
    }

    private void correctPertLevel(GraphicNode graphicNode, GraphicNode graphicNode2) {
        if (this.cache.getPertLevel(graphicNode2) <= this.cache.getPertLevel(graphicNode)) {
            this.cache.setPertLevel(graphicNode2, this.cache.getPertLevel(graphicNode) + 1);
        }
    }

    public class Node {
        protected Object value;
        protected List predecessors;
        protected List successors;

        public Node(Object object) {
            this.value = object;
            this.predecessors = new LinkedList();
            this.successors = new LinkedList();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public void addSuccessor(Node node) {
            this.successors.add(node);
        }

        public void removeSuccessor(Node node) {
            this.successors.remove(node);
        }

        public List getSuccessors() {
            return this.successors;
        }

        public void addPredecessor(Node node) {
            this.predecessors.add(node);
        }

        public void removePredecessor(Node node) {
            this.predecessors.remove(node);
        }

        public List getPredecessors() {
            return this.predecessors;
        }

        public boolean isolated() {
            return this.predecessors.size() == 0 && this.successors.size() == 0;
        }
    }
}

