/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.ClonableAudioStream;
import org.openhab.core.audio.utils.AudioStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class URLAudioStream
extends AudioStream
implements ClonableAudioStream {
    private static final Pattern PLS_STREAM_PATTERN = Pattern.compile("^File[0-9]=(.+)$");
    public static final String M3U_EXTENSION = "m3u";
    public static final String PLS_EXTENSION = "pls";
    private final Logger logger = LoggerFactory.getLogger(URLAudioStream.class);
    private final AudioFormat audioFormat;
    private final InputStream inputStream;
    private String url;
    private @Nullable Socket shoutCastSocket;

    public URLAudioStream(String url) throws AudioException {
        this.url = url;
        this.audioFormat = new AudioFormat("NONE", "MP3", false, 16, null, null);
        this.inputStream = this.createInputStream();
    }

    /*
     * Unable to fully structure code
     */
    private InputStream createInputStream() throws AudioException {
        filename = this.url.toLowerCase();
        extension = AudioStreamUtils.getExtension(filename);
        try {
            streamUrl = new URI(this.url).toURL();
            var4_6 = extension;
            tmp = -1;
            switch (var4_6.hashCode()) {
                case 106447: {
                    if (var4_6.equals("m3u")) {
                        tmp = 1;
                    }
                    break;
                }
                case 111095: {
                    if (var4_6.equals("pls")) {
                        tmp = 2;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    try {
                        var5_7 = null;
                        var6_13 = null;
                        try {
                            scanner = new Scanner(streamUrl.openStream(), StandardCharsets.UTF_8.name());
                            try {
                                while ((line = scanner.nextLine()).isEmpty() || line.startsWith("#")) {
                                }
                                this.url = line;
                                if (scanner == null) ** break;
                                scanner.close();
                                ** break;
                            }
                            catch (Throwable var5_8) {
                                if (scanner != null) {
                                    scanner.close();
                                }
                                throw var5_8;
lbl38:
                                // 2 sources

                            }
                        }
                        catch (Throwable var6_14) {
                            if (var5_7 == null) {
                                var5_7 = var6_14;
                            } else if (var5_7 != var6_14) {
                                var5_7.addSuppressed(var6_14);
                            }
                            throw var5_7;
                        }
                    }
                    catch (NoSuchElementException var5_9) {}
                    break;
                }
                case 2: {
                    try {
                        var5_7 = null;
                        var6_13 = null;
                        try {
                            scanner = new Scanner(streamUrl.openStream(), StandardCharsets.UTF_8.name());
                            try {
                                while ((line = scanner.nextLine()).isEmpty() || !line.startsWith("File") || !(matcher = URLAudioStream.PLS_STREAM_PATTERN.matcher(line)).find()) {
                                }
                                this.url = matcher.group(1);
                                if (scanner == null) ** break;
                                scanner.close();
                                ** break;
                            }
                            catch (Throwable var5_10) {
                                if (scanner != null) {
                                    scanner.close();
                                }
                                throw var5_10;
lbl65:
                                // 2 sources

                            }
                        }
                        catch (Throwable var6_15) {
                            if (var5_7 == null) {
                                var5_7 = var6_15;
                            } else if (var5_7 != var6_15) {
                                var5_7.addSuppressed(var6_15);
                            }
                            throw var5_7;
                        }
                    }
                    catch (NoSuchElementException var5_11) {}
                    break;
                }
            }
            streamUrl = new URI(this.url).toURL();
            connection = streamUrl.openConnection();
            if ("unknown/unknown".equals(connection.getContentType())) {
                port = streamUrl.getPort() > 0 ? streamUrl.getPort() : 80;
                this.shoutCastSocket = socket = new Socket(streamUrl.getHost(), port);
                os = socket.getOutputStream();
                userAgent = "WinampMPEG/5.09";
                req = "GET / HTTP/1.0\r\nuser-agent: " + userAgent + "\r\nIcy-MetaData: 1\r\nConnection: keep-alive\r\n\r\n";
                os.write(req.getBytes());
                return socket.getInputStream();
            }
            return connection.getInputStream();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.logger.error("URL '{}' is not a valid url: {}", new Object[]{this.url, e.getMessage(), e});
            throw new AudioException("URL not valid");
        }
        catch (IOException e) {
            this.logger.error("Cannot set up stream '{}': {}", new Object[]{this.url, e.getMessage(), e});
            throw new AudioException("IO Error");
        }
    }

    @Override
    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public void close() throws IOException {
        super.close();
        Socket socket = this.shoutCastSocket;
        if (socket instanceof Socket) {
            Socket socket2 = socket;
            socket2.close();
        }
    }

    public String toString() {
        return this.url;
    }

    @Override
    public InputStream getClonedStream() throws AudioException {
        return new URLAudioStream(this.url);
    }
}

