/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.permission;

import org.jboss.logging.Logger;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.permission.AbstractPermissionProvider;

public class UMAPolicyProvider
extends AbstractPermissionProvider {
    private static final Logger logger = Logger.getLogger(UMAPolicyProvider.class);

    @Override
    public void evaluate(Evaluation evaluation) {
        logger.debugf("UMA policy %s evaluating using parent class", (Object)evaluation.getPolicy().getName());
        ResourcePermission permission = evaluation.getPermission();
        Resource resource = permission.getResource();
        if (resource != null) {
            Identity identity = evaluation.getContext().getIdentity();
            if (resource.getOwner().equals(identity.getId())) {
                logger.debugv("UMA resource is owned by the current user, bypassing evaluation", new Object[0]);
                evaluation.grant();
                return;
            }
        }
        super.evaluate(evaluation);
    }
}

