/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.ICatch;
import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IDebugInfo;
import jadx.api.plugins.input.data.ITry;
import jadx.api.plugins.input.data.impl.CatchData;
import jadx.api.plugins.input.data.impl.TryData;
import jadx.api.plugins.input.insns.InsnData;
import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.insns.DexInsnData;
import jadx.plugins.input.dex.insns.DexInsnFormat;
import jadx.plugins.input.dex.insns.DexInsnInfo;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.debuginfo.DebugInfoParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class DexCodeReader
implements ICodeReader {
    private final SectionReader in;
    private int mthId;

    public DexCodeReader(SectionReader in) {
        this.in = in;
    }

    public DexCodeReader copy() {
        DexCodeReader copy = new DexCodeReader(this.in.copy());
        copy.setMthId(this.getMthId());
        return copy;
    }

    public void setOffset(int offset) {
        this.in.setOffset(offset);
    }

    public int getRegistersCount() {
        return this.in.pos(0).readUShort();
    }

    public int getArgsStartReg() {
        return -1;
    }

    public int getUnitsCount() {
        return this.in.pos(12).readInt();
    }

    public void visitInstructions(Consumer<InsnData> insnConsumer) {
        DexInsnData insnData = new DexInsnData(this, this.in.copy());
        this.in.pos(12);
        int size = this.in.readInt();
        for (int offset = 0; offset < size; offset += insnData.getLength()) {
            int insnStart = this.in.getAbsPos();
            int opcodeUnit = this.in.readUShort();
            DexInsnInfo insnInfo = DexInsnInfo.get(opcodeUnit);
            insnData.setInsnStart(insnStart);
            insnData.setOffset(offset);
            insnData.setInsnInfo(insnInfo);
            insnData.setOpcodeUnit(opcodeUnit);
            insnData.setPayload(null);
            insnData.setDecoded(false);
            if (insnInfo != null) {
                DexInsnFormat format = insnInfo.getFormat();
                insnData.setRegsCount(format.getRegsCount());
                insnData.setLength(format.getLength());
            } else {
                insnData.setRegsCount(0);
                insnData.setLength(1);
            }
            insnConsumer.accept(insnData);
            if (insnData.isDecoded()) continue;
            this.skip(insnData);
        }
    }

    public void decode(DexInsnData insn) {
        DexInsnFormat format = insn.getInsnInfo().getFormat();
        format.decode(insn, insn.getOpcodeUnit(), insn.getCodeData().in);
        insn.setDecoded(true);
    }

    public void skip(DexInsnData insn) {
        DexInsnInfo insnInfo = insn.getInsnInfo();
        if (insnInfo != null) {
            DexCodeReader codeReader = insn.getCodeData();
            insnInfo.getFormat().skip(insn, codeReader.in);
        }
    }

    @Nullable
    public IDebugInfo getDebugInfo() {
        int debugOff = this.in.pos(8).readInt();
        if (debugOff == 0) {
            return null;
        }
        int regsCount = this.getRegistersCount();
        DebugInfoParser debugInfoParser = new DebugInfoParser(this.in, regsCount, this.getUnitsCount());
        debugInfoParser.initMthArgs(regsCount, this.in.getMethodParamTypes(this.mthId));
        return debugInfoParser.process(debugOff);
    }

    private int getTriesCount() {
        return this.in.pos(6).readUShort();
    }

    private int getTriesOffset() {
        int triesCount = this.getTriesCount();
        if (triesCount == 0) {
            return -1;
        }
        int insnsCount = this.getUnitsCount();
        int padding = insnsCount % 2 == 1 ? 2 : 0;
        return 16 + insnsCount * 2 + padding;
    }

    public List<ITry> getTries() {
        int triesOffset = this.getTriesOffset();
        if (triesOffset == -1) {
            return Collections.emptyList();
        }
        int triesCount = this.getTriesCount();
        Map<Integer, ICatch> catchHandlers = this.getCatchHandlers(triesOffset + 8 * triesCount, this.in.copy());
        this.in.pos(triesOffset);
        ArrayList<ITry> triesList = new ArrayList<ITry>(triesCount);
        for (int i = 0; i < triesCount; ++i) {
            int startAddr = this.in.readInt();
            int insnsCount = this.in.readUShort();
            int handlerOff = this.in.readUShort();
            ICatch catchHandler = catchHandlers.get(handlerOff);
            if (catchHandler == null) {
                throw new DexException("Catch handler not found by byte offset: " + handlerOff);
            }
            triesList.add((ITry)new TryData(startAddr, startAddr + insnsCount - 1, catchHandler));
        }
        return triesList;
    }

    private Map<Integer, ICatch> getCatchHandlers(int offset, SectionReader ext) {
        this.in.pos(offset);
        int byteOffsetStart = this.in.getAbsPos();
        int size = this.in.readUleb128();
        HashMap<Integer, ICatch> map = new HashMap<Integer, ICatch>(size);
        for (int i = 0; i < size; ++i) {
            int byteIndex = this.in.getAbsPos() - byteOffsetStart;
            int sizeAndType = this.in.readSleb128();
            int handlersLen = Math.abs(sizeAndType);
            int[] addr = new int[handlersLen];
            String[] types = new String[handlersLen];
            for (int h = 0; h < handlersLen; ++h) {
                types[h] = ext.getType(this.in.readUleb128());
                addr[h] = this.in.readUleb128();
            }
            int catchAllAddr = sizeAndType <= 0 ? this.in.readUleb128() : -1;
            map.put(byteIndex, (ICatch)new CatchData(addr, types, catchAllAddr));
        }
        return map;
    }

    public int getCodeOffset() {
        return this.in.getOffset();
    }

    public void setMthId(int mthId) {
        this.mthId = mthId;
    }

    public int getMthId() {
        return this.mthId;
    }
}

