/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.help.ExtensionHelp;

public abstract class AbstractFormDialog
extends JDialog {
    private static final long serialVersionUID = -3345423228612477780L;
    private static final String CANCEL_BUTTON_LABEL = Constant.messages.getString("form.dialog.button.cancel");
    private JButton helpButton;
    private JButton confirmButton;
    private JButton cancelButton;
    private boolean firstTime;
    private String helpTarget;

    public AbstractFormDialog(Dialog owner, String title) {
        this(owner, title, true);
    }

    public AbstractFormDialog(Dialog owner, String title, boolean initView) {
        super((Window)owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initialise(initView);
    }

    public AbstractFormDialog(Frame owner, String title) {
        this(owner, title, true);
    }

    public AbstractFormDialog(Frame owner, String title, boolean initView) {
        super((Window)owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initialise(initView);
    }

    public AbstractFormDialog(Window owner, String title) {
        this(owner, title, true);
    }

    public AbstractFormDialog(Window owner, String title, boolean initView) {
        super(owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initialise(initView);
    }

    private void initialise(boolean initView) {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractFormDialog.this.clearAndHide();
            }
        });
        this.firstTime = true;
        if (initView) {
            this.initView();
        }
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -8088438488574461587L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFormDialog.this.clearAndHide();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    protected void initView() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonsPanel.add(this.getHelpButton());
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.getCancelButton());
        buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonsPanel.add(this.getConfirmButton());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getFieldsPanel(), "Center");
        panel.add((Component)buttonsPanel, "Last");
        this.setContentPane(panel);
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setIcon(ExtensionHelp.getHelpIcon());
            this.helpButton.setToolTipText(Constant.messages.getString("help.dialog.button.tooltip"));
            this.helpButton.setVisible(false);
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractFormDialog.this.helpTarget != null) {
                        ExtensionHelp.showHelp(AbstractFormDialog.this.helpTarget);
                    }
                }
            });
        }
        return this.helpButton;
    }

    protected void setHelpTarget(String helpTarget) {
        this.helpTarget = helpTarget;
        this.getHelpButton().setVisible(helpTarget != null);
    }

    private JButton getConfirmButton() {
        if (this.confirmButton == null) {
            this.confirmButton = new JButton(this.getConfirmButtonLabel());
            this.confirmButton.setEnabled(false);
            this.confirmButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractFormDialog.this.validateFields()) {
                        AbstractFormDialog.this.performAction();
                        AbstractFormDialog.this.clearAndHide();
                    }
                }
            });
        }
        return this.confirmButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(this.getCancelButtonLabel());
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractFormDialog.this.clearAndHide();
                }
            });
        }
        return this.cancelButton;
    }

    protected abstract JPanel getFieldsPanel();

    @Override
    public void setVisible(boolean b) {
        this.init();
        if (this.firstTime) {
            this.centreOnOwner();
            this.firstTime = false;
        }
        super.setVisible(b);
    }

    private void clearAndHide() {
        this.clearFields();
        this.dispose();
    }

    protected abstract String getConfirmButtonLabel();

    protected String getCancelButtonLabel() {
        return CANCEL_BUTTON_LABEL;
    }

    protected void setConfirmButtonEnabled(boolean enabled) {
        this.getConfirmButton().setEnabled(enabled);
    }

    protected void init() {
    }

    protected boolean validateFields() {
        return true;
    }

    protected void performAction() {
    }

    protected void clearFields() {
    }

    private void centreOnOwner() {
        Dimension frameSize = this.getSize();
        Rectangle mainrect = this.getOwner().getBounds();
        int x = mainrect.x + (mainrect.width - frameSize.width) / 2;
        int y = mainrect.y + (mainrect.height - frameSize.height) / 2;
        this.setLocation(x, y);
    }
}

