/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.calendar;

import com.projectlibre1.contrib.util.Log;
import com.projectlibre1.contrib.util.LogFactory;
import com.projectlibre1.pm.calendar.InvalidCalendarIntersectionException;
import com.projectlibre1.pm.calendar.WorkDay;
import com.projectlibre1.strings.Messages;
import java.io.Serializable;

public class WorkWeek
implements Cloneable,
Serializable {
    static final long serialVersionUID = 2555674567677L;
    public static final int DAYS_IN_WEEK = 7;
    public static final long MS_IN_WEEK = 604800000L;
    WorkDay[] workDay = new WorkDay[7];
    static Log log = LogFactory.getLog(WorkWeek.class);
    private static String WEEKDAY_MASK = new String(Messages.getString("Calendar.WeekdayBitMaskFromSundayToSaturday"));
    private long workingDuration = 0L;

    public Object clone() {
        log.info("WorkWeek.clone, " + this);
        WorkWeek workWeek = new WorkWeek();
        for (int i = 0; i < 7; ++i) {
            workWeek.workDay[i] = this.workDay[i] == null ? null : (WorkDay)this.workDay[i].clone();
        }
        return workWeek;
    }

    public WorkWeek(WorkDay[] workDayArray) {
        log.info("WorkWeek(), days=" + workDayArray);
        this.workDay = (WorkDay[])workDayArray.clone();
        this.updateWorkingDuration();
    }

    public WorkWeek() {
        log.info("WorkWeek()");
        for (int i = 0; i < 7; ++i) {
            this.workDay[i] = null;
        }
    }

    public WorkDay getWeekDay(int n) {
        return this.workDay[n];
    }

    WorkWeek intersectWith(WorkWeek workWeek) throws InvalidCalendarIntersectionException {
        WorkWeek workWeek2 = new WorkWeek();
        for (int i = 0; i < 7; ++i) {
            workWeek2.workDay[i] = this.workDay[i].intersectWith(workWeek.getWeekDay(i));
        }
        workWeek2.updateWorkingDuration();
        if (workWeek2.getDuration() == 0L) {
            throw new InvalidCalendarIntersectionException();
        }
        return workWeek2;
    }

    public void setWeekDay(int n, WorkDay workDay) {
        log.info("WorkWeek.setWeekDay, " + this + ", dayNum=" + n + ", day=" + workDay);
        if (workDay != null) {
            workDay.initialize();
        }
        this.workDay[n] = workDay;
        this.updateWorkingDuration();
    }

    public void setWeekDays(WorkDay workDay) {
        for (int i = 0; i < 7; ++i) {
            if (WEEKDAY_MASK.charAt(i) != '1') continue;
            this.setWeekDay(i, workDay);
        }
        this.updateWorkingDuration();
    }

    public void setWeekends(WorkDay workDay) {
        for (int i = 0; i < 7; ++i) {
            if (WEEKDAY_MASK.charAt(i) != '0') continue;
            this.setWeekDay(i, workDay);
        }
        this.updateWorkingDuration();
    }

    public void addDaysFrom(WorkWeek workWeek) {
        log.info("WorkWeek.addDaysFrom, " + this + ", from=" + workWeek);
        for (int i = 0; i < 7; ++i) {
            if (workWeek.workDay[i] != null) {
                this.workDay[i] = workWeek.workDay[i];
            }
            if (this.workDay[i] == null) {
                System.out.println();
                continue;
            }
            this.workDay[i].initialize();
        }
        this.updateWorkingDuration();
    }

    void updateWorkingDuration() {
        this.workingDuration = 0L;
        for (int i = 0; i < 7; ++i) {
            if (this.workDay[i] == null) continue;
            this.workingDuration += this.workDay[i].getDuration();
        }
    }

    public final long getDuration() {
        return this.workingDuration;
    }
}

