/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.www.mime.MimeTypeFormatException;

public class MimeType
implements Serializable,
Cloneable {
    public static MimeType TEXT_HTML = null;
    public static MimeType APPLICATION_POSTSCRIPT = null;
    public static MimeType TEXT_PLAIN = null;
    public static MimeType APPLICATION_X_WWW_FORM_URLENCODED = null;
    public static MimeType APPLICATION_OCTET_STREAM = null;
    public static MimeType MULTIPART_FORM_DATA = null;
    public static MimeType APPLICATION_X_JAVA_AGENT = null;
    public static MimeType MESSAGE_HTTP = null;
    public static MimeType TEXT_CSS = null;
    public static MimeType TEXT_XML = null;
    public static MimeType APPLICATION_XML = null;
    public static MimeType TEXT = null;
    public static MimeType APPLICATION_RDF_XML = null;
    public static MimeType APPLICATION_XHTML_XML = null;
    public static String star = "*".intern();
    public static final int NO_MATCH = -1;
    public static final int MATCH_TYPE = 1;
    public static final int MATCH_SPECIFIC_TYPE = 2;
    public static final int MATCH_SUBTYPE = 3;
    public static final int MATCH_SPECIFIC_SUBTYPE = 4;
    protected String type = null;
    protected String subtype = null;
    protected String[] pnames = null;
    protected String[] pvalues = null;
    protected String external = null;

    public int match(MimeType other) {
        int match = -1;
        if (this.type == star || other.type == star) {
            return 1;
        }
        if (this.type != other.type) {
            return -1;
        }
        match = 2;
        if (this.subtype == star || other.subtype == star) {
            match = 3;
        } else {
            if (this.subtype != other.subtype) {
                return -1;
            }
            match = 4;
        }
        return match;
    }

    public boolean equiv(MimeType mtype) {
        if (this.match(mtype) == 4) {
            return true;
        }
        return !(this.match(TEXT_XML) != 4 && this.match(APPLICATION_XML) != 4 || mtype.match(TEXT_XML) != 4 && mtype.match(APPLICATION_XML) != 4);
    }

    public String toString() {
        if (this.external == null) {
            StringBuilder sb = new StringBuilder(this.type);
            sb.append('/');
            sb.append(this.subtype);
            if (this.pnames != null) {
                for (int i = 0; i < this.pnames.length; ++i) {
                    sb.append(';');
                    sb.append(this.pnames[i]);
                    if (this.pvalues[i] == null) continue;
                    sb.append('=');
                    sb.append(this.pvalues[i]);
                }
            }
            this.external = sb.toString().intern();
        }
        return this.external;
    }

    public boolean hasParameter(String name) {
        if (name != null && this.pnames != null) {
            String lname = name.toLowerCase();
            for (String pname : this.pnames) {
                if (!pname.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getParameterValue(String name) {
        if (name != null && this.pnames != null) {
            String lname = name.toLowerCase();
            for (int i = 0; i < this.pnames.length; ++i) {
                if (!this.pnames[i].equals(lname)) continue;
                return this.pvalues[i];
            }
        }
        return null;
    }

    public void addParameters(String[] param, String[] values) {
        if (param == null || values == null || values.length != param.length) {
            return;
        }
        if (this.pnames == null) {
            this.pnames = param;
            this.pvalues = values;
        } else {
            String[] nparam = new String[this.pnames.length + param.length];
            String[] nvalues = new String[this.pvalues.length + values.length];
            System.arraycopy(this.pnames, 0, nparam, 0, this.pnames.length);
            System.arraycopy(param, 0, nparam, this.pnames.length, param.length);
            System.arraycopy(this.pvalues, 0, nvalues, 0, this.pvalues.length);
            System.arraycopy(values, 0, nvalues, this.pvalues.length, values.length);
            this.pnames = nparam;
            this.pvalues = nvalues;
        }
        for (int i = 0; i < this.pnames.length; ++i) {
            this.pnames[i] = this.pnames[i].toLowerCase();
        }
        this.external = null;
    }

    public MimeType getClone() {
        try {
            return (MimeType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void addParameter(String param, String value) {
        String[] p = new String[1];
        String[] v = new String[1];
        p[0] = param;
        v[0] = value;
        this.addParameters(p, v);
    }

    public void setParameter(String param, String value) {
        if (this.pnames == null) {
            this.addParameter(param, value);
        } else {
            String lparam = param.toLowerCase();
            for (int i = 0; i < this.pnames.length; ++i) {
                if (!this.pnames[i].equals(lparam)) continue;
                this.pvalues[i] = value;
                return;
            }
            this.addParameter(lparam, value);
        }
    }

    public MimeType(String spec) throws MimeTypeFormatException {
        int start;
        int strl = spec.length();
        int look = -1;
        for (start = 0; start < strl && spec.charAt(start) <= ' '; ++start) {
        }
        while (strl > start && spec.charAt(strl - 1) <= ' ') {
            --strl;
        }
        StringBuilder sb = new StringBuilder();
        while (start < strl) {
            char c = spec.charAt(start);
            look = c;
            if (c == '/') break;
            sb.append(Character.toLowerCase((char)look));
            ++start;
        }
        if (look != 47) {
            throw new MimeTypeFormatException(spec);
        }
        this.type = sb.toString().intern();
        ++start;
        sb.setLength(0);
        while (start < strl) {
            char c = spec.charAt(start);
            look = c;
            if (c <= ' ' || look == 59) break;
            sb.append(Character.toLowerCase((char)look));
            ++start;
        }
        this.subtype = sb.toString().intern();
        while (start < strl) {
            char c = spec.charAt(start);
            look = c;
            if (c > ' ') break;
            ++start;
        }
        if (start < strl) {
            if (spec.charAt(start) != ';') {
                throw new MimeTypeFormatException(spec);
            }
            ++start;
            ArrayList<String> vp = new ArrayList<String>(4);
            ArrayList<String> vv = new ArrayList<String>(4);
            while (start < strl) {
                while (start < strl && spec.charAt(start) <= ' ') {
                    ++start;
                }
                sb.setLength(0);
                while (start < strl) {
                    char c = spec.charAt(start);
                    look = c;
                    if (c <= ' ' || look == 61) break;
                    sb.append(Character.toLowerCase((char)look));
                    ++start;
                }
                String name = sb.toString();
                while (start < strl && spec.charAt(start) <= ' ') {
                    ++start;
                }
                if (spec.charAt(start) != '=') {
                    throw new MimeTypeFormatException(spec);
                }
                ++start;
                while (start < strl && (spec.charAt(start) == '\"' || spec.charAt(start) <= ' ')) {
                    ++start;
                }
                sb.setLength(0);
                while (start < strl) {
                    char c = spec.charAt(start);
                    look = c;
                    if (c <= ' ' || look == 59 || look == 34) break;
                    sb.append((char)look);
                    ++start;
                }
                while (start < strl && spec.charAt(start) != ';') {
                    ++start;
                }
                ++start;
                String value = sb.toString();
                vp.add(name);
                vv.add(value);
            }
            this.pnames = vp.toArray(new String[vp.size()]);
            this.pvalues = vv.toArray(new String[vv.size()]);
        }
    }

    public MimeType(String type, String subtype, String[] pnames, String[] pvalues) {
        this.type = type.toLowerCase().intern();
        this.subtype = subtype.toLowerCase().intern();
        this.pnames = pnames;
        this.pvalues = pvalues;
    }

    public MimeType(String type, String subtype) {
        this.type = type.toLowerCase().intern();
        this.subtype = subtype.toLowerCase().intern();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            MimeType type = null;
            try {
                type = new MimeType(args[0]);
            }
            catch (MimeTypeFormatException mimeTypeFormatException) {
                // empty catch block
            }
            if (type != null) {
                System.out.println(type);
                if (type.getClone().match(type) == 4) {
                    System.out.println("Clone OK");
                } else {
                    System.out.println("Cloning failed");
                }
            } else {
                System.out.println("Invalid mime type specification.");
            }
        } else {
            System.out.println("Usage: java MimeType <type-to-parse>");
        }
    }

    static {
        try {
            TEXT_HTML = new MimeType("text/html");
            APPLICATION_POSTSCRIPT = new MimeType("application/postscript");
            TEXT_PLAIN = new MimeType("text/plain");
            APPLICATION_X_WWW_FORM_URLENCODED = new MimeType("application/x-www-form-urlencoded");
            APPLICATION_OCTET_STREAM = new MimeType("application/octet-stream");
            MULTIPART_FORM_DATA = new MimeType("multipart/form-data");
            APPLICATION_X_JAVA_AGENT = new MimeType("application/x-java-agent");
            MESSAGE_HTTP = new MimeType("message/http");
            TEXT_CSS = new MimeType("text/css");
            TEXT_XML = new MimeType("text/xml");
            TEXT = new MimeType("text/*");
            APPLICATION_RDF_XML = new MimeType("application/rdf+xml");
            APPLICATION_XHTML_XML = new MimeType("application/xhtml+xml");
            APPLICATION_XML = new MimeType("application/xml");
        }
        catch (MimeTypeFormatException e) {
            System.out.println("httpd.MimeType: invalid static init.");
            System.exit(1);
        }
    }
}

