/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.SerializedJwt;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;

public class CachedFile<T> {
    public static final Transformer<String> STRING_NOOP_TRANSFORMER = (file, contents) -> contents;
    public static final Transformer<String> STRING_JSON_VALIDATING_TRANSFORMER = (file, contents) -> {
        contents = contents.trim();
        SerializedJwt serializedJwt = new SerializedJwt(contents);
        OAuthBearerUnsecuredJws.toMap(serializedJwt.getHeader());
        OAuthBearerUnsecuredJws.toMap(serializedJwt.getPayload());
        return contents;
    };
    private final File file;
    private final Transformer<T> transformer;
    private final RefreshPolicy<T> cacheRefreshPolicy;
    private Snapshot<T> snapshot;

    public CachedFile(File file, Transformer<T> transformer, RefreshPolicy<T> cacheRefreshPolicy) {
        this.file = file;
        this.transformer = transformer;
        this.cacheRefreshPolicy = cacheRefreshPolicy;
        this.snapshot = this.snapshot();
    }

    public long size() {
        return this.snapshot().size();
    }

    public long lastModified() {
        return this.snapshot().lastModified();
    }

    public String contents() {
        return this.snapshot().contents();
    }

    public T transformed() {
        return this.snapshot().transformed();
    }

    private Snapshot<T> snapshot() {
        if (this.cacheRefreshPolicy.shouldRefresh(this.file, this.snapshot)) {
            String contents;
            long size = this.file.length();
            long lastModified = this.file.lastModified();
            try {
                contents = Files.readString(this.file.toPath());
            }
            catch (IOException e) {
                throw new KafkaException("Error reading the file contents of OAuth resource " + this.file.getPath() + " for caching");
            }
            T transformed = this.transformer.transform(this.file, contents);
            this.snapshot = new Snapshot<T>(size, lastModified, contents, transformed);
        }
        return this.snapshot;
    }

    public static interface Transformer<T> {
        public T transform(File var1, String var2);
    }

    public static interface RefreshPolicy<T> {
        public boolean shouldRefresh(File var1, Snapshot<T> var2);

        public static <T> RefreshPolicy<T> staticPolicy() {
            return (file, snapshot) -> snapshot == null;
        }

        public static <T> RefreshPolicy<T> lastModifiedPolicy() {
            return (file, snapshot) -> {
                if (snapshot == null) {
                    return true;
                }
                return file.lastModified() != snapshot.lastModified();
            };
        }
    }

    public static class Snapshot<T> {
        private final long size;
        private final long lastModified;
        private final String contents;
        private final T transformed;

        public Snapshot(long size, long lastModified, String contents, T transformed) {
            this.size = size;
            this.lastModified = lastModified;
            this.contents = contents;
            this.transformed = transformed;
        }

        public long size() {
            return this.size;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public String contents() {
            return this.contents;
        }

        public T transformed() {
            return this.transformed;
        }
    }
}

