/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.AggregateQuery;
import com.google.firestore.v1.Value;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class AggregateQuerySnapshot {
    @Nonnull
    private final AggregateQuery query;
    @Nonnull
    private final Timestamp readTime;
    @Nonnull
    private final Map<String, Value> data;

    AggregateQuerySnapshot(@Nonnull AggregateQuery query, @Nonnull Timestamp readTime, @Nonnull Map<String, Value> data) {
        this.query = query;
        this.readTime = readTime;
        this.data = data;
    }

    @Nonnull
    public AggregateQuery getQuery() {
        return this.query;
    }

    @Nonnull
    public Timestamp getReadTime() {
        return this.readTime;
    }

    public long getCount() {
        AggregateField.CountAggregateField countField = AggregateField.count();
        Object value = this.get((AggregateField)countField);
        if (value == null) {
            throw new IllegalArgumentException("RunAggregationQueryResponse alias " + countField.getAlias() + " is null");
        }
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("RunAggregationQueryResponse alias " + countField.getAlias() + " has incorrect type: " + value.getClass().getName());
        }
        return (Long)value;
    }

    public long get(@Nonnull AggregateField.CountAggregateField unused) {
        return this.getCount();
    }

    @Nullable
    public Object get(@Nonnull AggregateField aggregateField) {
        if (!this.data.containsKey(aggregateField.getAlias())) {
            throw new IllegalArgumentException("'" + aggregateField.getOperator() + "(" + aggregateField.getFieldPath() + ")' was not requested in the aggregation query.");
        }
        Value value = this.data.get(aggregateField.getAlias());
        if (value.hasNullValue()) {
            return null;
        }
        if (value.hasDoubleValue()) {
            return value.getDoubleValue();
        }
        if (value.hasIntegerValue()) {
            return value.getIntegerValue();
        }
        throw new IllegalStateException("Found aggregation result that is not an integer nor double");
    }

    @Nullable
    public Double get(@Nonnull AggregateField.AverageAggregateField averageAggregateField) {
        return (Double)this.get((AggregateField)averageAggregateField);
    }

    @Nullable
    public Double getDouble(@Nonnull AggregateField aggregateField) {
        Number result = (Number)this.get(aggregateField);
        return result == null ? null : Double.valueOf(result.doubleValue());
    }

    @Nullable
    public Long getLong(@Nonnull AggregateField aggregateField) {
        Number result = (Number)this.get(aggregateField);
        return result == null ? null : Long.valueOf(result.longValue());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AggregateQuerySnapshot)) {
            return false;
        }
        AggregateQuerySnapshot other = (AggregateQuerySnapshot)object;
        return this.query.equals(other.query) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.data);
    }
}

