/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.OSGiRunnable;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.Pad;

public class DistributeOSGiImpl<T, S>
extends OSGiImpl<S> {
    @SafeVarargs
    public DistributeOSGiImpl(OSGiRunnable<T> operation, Function<OSGi<T>, OSGi<S>> ... funs) {
        super((bundleContext, publisher) -> {
            Pad[] pads = new Pad[funs.length];
            for (int i = 0; i < funs.length; ++i) {
                pads[i] = new Pad(bundleContext, funs[i], publisher);
            }
            OSGiResult result = operation.run(bundleContext, t -> {
                ArrayList<Runnable> terminators = new ArrayList<Runnable>(funs.length);
                try {
                    for (int i = 0; i < funs.length; ++i) {
                        terminators.add(pads[i].publish(t));
                    }
                }
                catch (Exception e) {
                    DistributeOSGiImpl.cleanUp(terminators);
                    throw e;
                }
                return () -> DistributeOSGiImpl.cleanUp(terminators);
            });
            return () -> {
                result.close();
                for (Pad pad : pads) {
                    try {
                        pad.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        });
    }

    private static void cleanUp(List<Runnable> terminators) {
        ListIterator<Runnable> iterator = terminators.listIterator(terminators.size());
        while (iterator.hasPrevious()) {
            try {
                iterator.previous().run();
            }
            catch (Exception exception) {}
        }
    }
}

