/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import java.math.BigDecimal;
import java.math.MathContext;
import org.rrd4j.core.Util;
import org.rrd4j.graph.Axis;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.Mapper;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphGenerator;

class ValueAxis
extends Axis {
    private static final YLabel[] ylabels = new YLabel[]{new YLabel(0.1, 1, 2, 5, 10), new YLabel(0.2, 1, 5, 10, 20), new YLabel(0.5, 1, 2, 4, 10), new YLabel(1.0, 1, 2, 5, 10), new YLabel(2.0, 1, 5, 10, 20), new YLabel(5.0, 1, 2, 4, 10), new YLabel(10.0, 1, 2, 5, 10), new YLabel(20.0, 1, 5, 10, 20), new YLabel(50.0, 1, 2, 4, 10), new YLabel(100.0, 1, 2, 5, 10), new YLabel(200.0, 1, 5, 10, 20), new YLabel(500.0, 1, 2, 4, 10), new YLabel(1000.0, 1, 2, 5, 10), new YLabel(2000.0, 1, 5, 10, 20), new YLabel(5000.0, 1, 2, 4, 10), new YLabel(10000.0, 1, 2, 5, 10), new YLabel(20000.0, 1, 5, 10, 20), new YLabel(50000.0, 1, 2, 4, 10), new YLabel(100000.0, 1, 2, 5, 10), new YLabel(0.0, 0, 0, 0, 0)};
    private final ImageParameters im;
    private final ImageWorker worker;
    private final RrdGraphDef gdef;
    private final Mapper mapper;

    ValueAxis(RrdGraph rrdGraph, ImageWorker worker) {
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = worker;
        this.mapper = new Mapper(this.gdef, this.im);
    }

    ValueAxis(RrdGraphGenerator generator) {
        this.im = generator.im;
        this.gdef = generator.gdef;
        this.worker = generator.worker;
        this.mapper = generator.mapper;
    }

    @Override
    boolean draw() {
        int labfact;
        double gridstep;
        Font font = this.gdef.getFont(FONTTAG_AXIS);
        Paint gridColor = this.gdef.getColor(ElementsNames.grid);
        Paint mGridColor = this.gdef.getColor(ElementsNames.mgrid);
        Paint fontColor = this.gdef.getColor(ElementsNames.font);
        int labelOffset = (int)(this.worker.getFontAscent(font) / 2.0);
        double range = this.im.maxval - this.im.minval;
        double scaledrange = range / this.im.magfact;
        if (Double.isNaN(scaledrange)) {
            return false;
        }
        String labfmt = null;
        if (Double.isNaN(this.im.ygridstep)) {
            if (this.gdef.altYGrid) {
                int fractionals;
                int decimals = (int)Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                if (decimals <= 0) {
                    decimals = 1;
                }
                labfmt = (fractionals = (int)Math.floor(Math.log10(range))) < 0 ? Util.sprintf(this.gdef.locale, "%%%d.%df", decimals - fractionals + 1, -fractionals + 1) : Util.sprintf(this.gdef.locale, "%%%d.1f", decimals + 1);
                gridstep = Math.pow(10.0, fractionals);
                if (gridstep == 0.0) {
                    gridstep = 0.1;
                }
                if (range / gridstep < 5.0) {
                    gridstep /= 10.0;
                }
                if (range / gridstep > 15.0) {
                    gridstep *= 10.0;
                }
                if (range / gridstep > 5.0) {
                    labfact = 1;
                    if (range / gridstep > 8.0) {
                        labfact = 2;
                    }
                } else {
                    gridstep /= 5.0;
                    labfact = 5;
                }
            } else {
                int minimumLabelCount = 3;
                YLabel selectedYLabel = null;
                while (selectedYLabel == null) {
                    selectedYLabel = this.findYLabel(minimumLabelCount);
                    --minimumLabelCount;
                }
                gridstep = selectedYLabel.grid * this.im.magfact;
                labfact = this.findLabelFactor(selectedYLabel);
                if (labfact == -1) {
                    labfact = selectedYLabel.labelFacts[3];
                }
            }
        } else {
            gridstep = this.im.ygridstep;
            labfact = this.im.ylabfact;
        }
        int x0 = this.im.xorigin;
        int x1 = x0 + this.im.xsize;
        int sgrid = (int)(this.im.minval / gridstep - 1.0);
        int egrid = (int)(this.im.maxval / gridstep + 1.0);
        double scaledstep = gridstep / this.im.magfact;
        boolean fractional = ValueAxis.isFractional(scaledstep, labfact);
        for (int i = sgrid; i <= egrid; ++i) {
            int y = this.mapper.ytr(gridstep * (double)i);
            if (y < this.im.yorigin - this.im.ysize || y > this.im.yorigin) continue;
            if (i % labfact == 0) {
                String graph_label = i == 0 || this.im.symbol == ' ' ? (fractional ? (i != 0 && this.gdef.altYGrid ? Util.sprintf(this.gdef.locale, labfmt, scaledstep * (double)i) : Util.sprintf(this.gdef.locale, "%4.1f", scaledstep * (double)i)) : Util.sprintf(this.gdef.locale, "%4.0f", scaledstep * (double)i)) : (this.im.symbol == 'm' ? Util.sprintf(this.gdef.locale, "%.3f", scaledstep * (double)i / 1000.0) : (fractional ? Util.sprintf(this.gdef.locale, "%4.1f %c", scaledstep * (double)i, Character.valueOf(this.im.symbol)) : Util.sprintf(this.gdef.locale, "%4.0f %c", scaledstep * (double)i, Character.valueOf(this.im.symbol))));
                int length = (int)this.worker.getStringWidth(graph_label, font);
                this.worker.drawString(graph_label, x0 - length - 7, y + labelOffset, font, fontColor);
                if (this.gdef.drawTicks()) {
                    this.worker.drawLine(x0 - 2, y, x0 + 2, y, mGridColor, this.gdef.tickStroke);
                    this.worker.drawLine(x1 - 2, y, x1 + 2, y, mGridColor, this.gdef.tickStroke);
                }
                this.worker.drawLine(x0, y, x1, y, mGridColor, this.gdef.gridStroke);
                continue;
            }
            if (this.gdef.noMinorGrid) continue;
            if (this.gdef.drawTicks()) {
                this.worker.drawLine(x0 - 1, y, x0 + 1, y, gridColor, this.gdef.tickStroke);
                this.worker.drawLine(x1 - 1, y, x1 + 1, y, gridColor, this.gdef.tickStroke);
            }
            this.worker.drawLine(x0, y, x1, y, gridColor, this.gdef.gridStroke);
        }
        return true;
    }

    private YLabel findYLabel(int desiredMinimumLabelCount) {
        double val;
        double scaledrange = this.getScaledRange();
        int i = 0;
        while (ValueAxis.ylabels[i].grid > 0.0) {
            YLabel thisYLabel = ylabels[i];
            if (this.getPixelsPerGridline(thisYLabel) > 5) {
                if (this.im.minval < 0.0 && this.im.maxval > 0.0) {
                    int labelCount;
                    int labelFactor = this.findLabelFactor(thisYLabel);
                    if (labelFactor == -1) {
                        int n = labelFactor = desiredMinimumLabelCount == 1 ? 1 : desiredMinimumLabelCount + 1;
                    }
                    if ((labelCount = (int)(scaledrange / thisYLabel.grid) / labelFactor + 1) > desiredMinimumLabelCount) {
                        return thisYLabel;
                    }
                } else {
                    return thisYLabel;
                }
            }
            ++i;
        }
        for (val = 1.0; val < scaledrange; val *= 10.0) {
        }
        return new YLabel(val / 10.0, 1, 2, 5, 10);
    }

    private int findLabelFactor(YLabel thisYLabel) {
        int pixel = this.getPixelsPerGridline(thisYLabel);
        int fontHeight = (int)Math.ceil(this.worker.getFontHeight(this.gdef.getFont(FONTTAG_AXIS)));
        for (int j = 0; j < 4; ++j) {
            if (pixel * thisYLabel.labelFacts[j] < 2 * fontHeight) continue;
            return thisYLabel.labelFacts[j];
        }
        return -1;
    }

    private int getPixelsPerGridline(YLabel thisYLabel) {
        double scaledrange = this.getScaledRange();
        return (int)((double)this.im.ysize / (scaledrange / thisYLabel.grid));
    }

    private double getScaledRange() {
        double range = this.im.maxval - this.im.minval;
        return range / this.im.magfact;
    }

    private static boolean isFractional(double scaledstep, int labfact) {
        if (scaledstep >= 1.0) {
            return false;
        }
        BigDecimal bd = BigDecimal.valueOf(scaledstep).multiply(BigDecimal.valueOf(labfact), MathContext.DECIMAL32);
        return bd.signum() != 0 && bd.scale() > 0 && bd.stripTrailingZeros().scale() > 0;
    }

    static class YLabel {
        final double grid;
        final int[] labelFacts;

        YLabel(double grid, int lfac1, int lfac2, int lfac3, int lfac4) {
            this.grid = grid;
            this.labelFacts = new int[]{lfac1, lfac2, lfac3, lfac4};
        }
    }
}

