/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtendedRandomExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtendedRandomExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtendedRandomExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedRandomExtensionHandler
extends ExtensionHandler<ExtendedRandomExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ExtendedRandomExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public ExtendedRandomExtensionParser getParser(byte[] message, int pointer) {
        return new ExtendedRandomExtensionParser(pointer, message);
    }

    public ExtendedRandomExtensionPreparator getPreparator(ExtendedRandomExtensionMessage message) {
        return new ExtendedRandomExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public ExtendedRandomExtensionSerializer getSerializer(ExtendedRandomExtensionMessage message) {
        return new ExtendedRandomExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(ExtendedRandomExtensionMessage message) {
        if (this.context.getTalkingConnectionEndType().equals((Object)ConnectionEndType.SERVER)) {
            this.context.setServerExtendedRandom((byte[])message.getExtendedRandom().getValue());
            LOGGER.debug("The context server extended Random was set to " + ArrayConverter.bytesToHexString((ModifiableByteArray)message.getExtendedRandom()));
        }
        if (this.context.getTalkingConnectionEndType().equals((Object)ConnectionEndType.CLIENT)) {
            this.context.setClientExtendedRandom((byte[])message.getExtendedRandom().getValue());
            LOGGER.debug("The context client extended Random was set to " + ArrayConverter.bytesToHexString((ModifiableByteArray)message.getExtendedRandom()));
        }
        if (this.context.getClientExtendedRandom() != null && this.context.getServerExtendedRandom() != null) {
            LOGGER.debug("Extended Random was agreed on. Concatenating extended Randoms to normal Randoms.");
            byte[] clientConcatRandom = ArrayConverter.concatenate((byte[][])new byte[][]{this.context.getClientRandom(), this.context.getClientExtendedRandom()});
            byte[] serverConcatRandom = ArrayConverter.concatenate((byte[][])new byte[][]{this.context.getServerRandom(), this.context.getServerExtendedRandom()});
            this.context.setClientRandom(clientConcatRandom);
            LOGGER.debug("ClientRandom: " + ArrayConverter.bytesToHexString((byte[])this.context.getClientRandom()));
            this.context.setServerRandom(serverConcatRandom);
            LOGGER.debug("ServerRandom: " + ArrayConverter.bytesToHexString((byte[])this.context.getServerRandom()));
        }
    }
}

