/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.awt.geom.Point2D;
import java.beans.PropertyEditorSupport;
import org.jdesktop.swingx.editors.PropertyEditorUtil;

public class Point2DPropertyEditor
extends PropertyEditorSupport {
    public Point2D getValue() {
        return (Point2D)super.getValue();
    }

    public String getJavaInitializationString() {
        Point2D point = this.getValue();
        return point == null ? "null" : "new java.awt.geom.Point2D.Double(" + point.getX() + ", " + point.getY() + ")";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String originalParam = text;
        try {
            Point2D val = (Point2D)PropertyEditorUtil.createValueFromString(text, 2, Point2D.Double.class, Double.TYPE);
            this.setValue(val);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw new IllegalArgumentException("The input value " + originalParam + " is not formatted correctly. Please " + "try something of the form [x,y] or [x , y] or [x y]", e);
        }
    }

    public String getAsText() {
        Point2D point = this.getValue();
        return point == null ? "[]" : "[" + point.getX() + ", " + point.getY() + "]";
    }

    public static void main(String ... args) {
        Point2DPropertyEditor.test("[1.5,1.2]");
        Point2DPropertyEditor.test("1.5,1.2]");
        Point2DPropertyEditor.test("[1.5,1.2");
        Point2DPropertyEditor.test("[ 1.5 , 1.2 ]");
        Point2DPropertyEditor.test(" 1.5 , 1.2 ]");
        Point2DPropertyEditor.test("[ 1.5 , 1.2");
        Point2DPropertyEditor.test("1.5,1.2");
        Point2DPropertyEditor.test(" 1.5 , 1.2 ");
        Point2DPropertyEditor.test("1.5 1.2");
        Point2DPropertyEditor.test("");
        Point2DPropertyEditor.test("null");
        Point2DPropertyEditor.test("[]");
        Point2DPropertyEditor.test("[ ]");
        Point2DPropertyEditor.test("[1.5 1.2]");
    }

    private static void test(String input) {
        System.out.print("Input '" + input + "'");
        try {
            Point2DPropertyEditor ed = new Point2DPropertyEditor();
            ed.setAsText(input);
            Point2D point = ed.getValue();
            System.out.println(" succeeded: " + point);
        }
        catch (Exception e) {
            System.out.println(" failed: " + e.getMessage());
        }
    }
}

