/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ConditionalExpression
extends Expression {
    private final Expression condition;
    private final OperatorType operator;
    private final Expression ifTrue;
    private final Expression ifFalse;

    public ConditionalExpression(int start, int end, Expression condition, OperatorType operator, Expression ifTrue, Expression ifFalse) {
        super(start, end);
        if (condition == null || ifFalse == null) {
            throw new IllegalArgumentException();
        }
        this.condition = condition;
        this.operator = operator;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public OperatorType getOperator() {
        return this.operator;
    }

    public Expression getIfTrue() {
        return this.ifTrue;
    }

    public Expression getIfFalse() {
        return this.ifFalse;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getCondition() + " ? " + this.getIfTrue() + " : " + this.getIfFalse();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OperatorType {
        QUESTION_MARK("?"){

            @Override
            public boolean isOperatorToken(Token<PHPTokenId> token) {
                throw new IllegalStateException();
            }
        }
        ,
        ELVIS("?:", true){

            @Override
            public boolean isOperatorToken(Token<PHPTokenId> token) {
                assert (false);
                return false;
            }
        }
        ,
        COALESCE("??", true){

            @Override
            public boolean isOperatorToken(Token<PHPTokenId> token) {
                return token.id() == PHPTokenId.PHP_OPERATOR && TokenUtilities.textEquals((CharSequence)"??", (CharSequence)token.text());
            }
        };

        private final String operatorSign;
        private final boolean shortened;

        private OperatorType(String operatorSign) {
            this(operatorSign, false);
        }

        private OperatorType(String operatorSign, boolean shortened) {
            this.operatorSign = operatorSign;
            this.shortened = shortened;
        }

        public abstract boolean isOperatorToken(Token<PHPTokenId> var1);

        public boolean isShortened() {
            return this.shortened;
        }

        public String toString() {
            return this.operatorSign;
        }
    }
}

