/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.conditionapi;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.LinkedList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.declarative.conditionapi.Context;
import org.netbeans.modules.java.hints.declarative.conditionapi.Variable;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.MatcherUtilities;

public final class Matcher {
    private final Context ctx;

    public Matcher(Context ctx) {
        this.ctx = ctx;
    }

    public boolean matches(@NonNull Variable var, @NonNull String pattern) {
        return this.matchesAny(var, pattern);
    }

    public boolean matchesAny(@NonNull Variable var, String ... patterns) {
        Iterable<? extends TreePath> paths = this.ctx.getVariable(var);
        if (paths == null) {
            return false;
        }
        for (String pattern : patterns) {
            for (TreePath treePath : paths) {
                if (!MatcherUtilities.matches((HintContext)this.ctx.ctx, (TreePath)treePath, (String)pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAny(@NonNull Variable var, final String ... patterns) {
        Iterable<? extends TreePath> paths = this.ctx.getVariable(var);
        final boolean[] result = new boolean[1];
        if (paths == null) {
            return false;
        }
        for (TreePath treePath : paths) {
            new ErrorAwareTreePathScanner<Void, Void>(){

                public Void scan(Tree tree, Void p) {
                    if (tree == null) {
                        return null;
                    }
                    TreePath tp = new TreePath(this.getCurrentPath(), tree);
                    for (String pattern : patterns) {
                        if (!MatcherUtilities.matches((HintContext)((Matcher)Matcher.this).ctx.ctx, (TreePath)tp, (String)pattern)) continue;
                        result[0] = true;
                    }
                    return (Void)super.scan(tree, (Object)p);
                }
            }.scan(treePath, null);
        }
        return result[0];
    }

    public boolean referencedIn(@NonNull Variable variable, @NonNull Variable in) {
        return Utilities.isReferencedIn((CompilationInfo)this.ctx.ctx.getInfo(), (TreePath)this.ctx.getSingleVariable(variable), this.ctx.getVariable(in));
    }

    public boolean matchesWithBind(Variable var, String pattern) {
        TreePath path = this.ctx.getSingleVariable(var);
        if (path != null) {
            return MatcherUtilities.matches((HintContext)this.ctx.ctx, (TreePath)path, (String)pattern, this.ctx.variables.getFirst(), this.ctx.multiVariables.getFirst(), this.ctx.variableNames.getFirst());
        }
        Iterable<? extends Variable> multiVar = this.ctx.getIndexedVariables(var);
        LinkedList<TreePath> multi = new LinkedList<TreePath>();
        for (Variable variable : multiVar) {
            multi.add(this.ctx.getSingleVariable(variable));
        }
        return MatcherUtilities.matches((HintContext)this.ctx.ctx, multi, (String)pattern, this.ctx.variables.getFirst(), this.ctx.multiVariables.getFirst(), this.ctx.variableNames.getFirst());
    }
}

