/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VulnerabilityAuditConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="maxPermissibleCvssV2Score")
    private final Float maxPermissibleCvssV2Score;
    @JsonProperty(value="maxPermissibleCvssV3Score")
    private final Float maxPermissibleCvssV3Score;
    @JsonProperty(value="exclusions")
    private final List<String> exclusions;

    @Deprecated
    @ConstructorProperties(value={"maxPermissibleCvssV2Score", "maxPermissibleCvssV3Score", "exclusions"})
    public VulnerabilityAuditConfiguration(Float maxPermissibleCvssV2Score, Float maxPermissibleCvssV3Score, List<String> exclusions) {
        this.maxPermissibleCvssV2Score = maxPermissibleCvssV2Score;
        this.maxPermissibleCvssV3Score = maxPermissibleCvssV3Score;
        this.exclusions = exclusions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getMaxPermissibleCvssV2Score() {
        return this.maxPermissibleCvssV2Score;
    }

    public Float getMaxPermissibleCvssV3Score() {
        return this.maxPermissibleCvssV3Score;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VulnerabilityAuditConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("maxPermissibleCvssV2Score=").append(String.valueOf(this.maxPermissibleCvssV2Score));
        sb.append(", maxPermissibleCvssV3Score=").append(String.valueOf(this.maxPermissibleCvssV3Score));
        sb.append(", exclusions=").append(String.valueOf(this.exclusions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilityAuditConfiguration)) {
            return false;
        }
        VulnerabilityAuditConfiguration other = (VulnerabilityAuditConfiguration)((Object)o);
        return Objects.equals(this.maxPermissibleCvssV2Score, other.maxPermissibleCvssV2Score) && Objects.equals(this.maxPermissibleCvssV3Score, other.maxPermissibleCvssV3Score) && Objects.equals(this.exclusions, other.exclusions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.maxPermissibleCvssV2Score == null ? 43 : this.maxPermissibleCvssV2Score.hashCode());
        result = result * 59 + (this.maxPermissibleCvssV3Score == null ? 43 : this.maxPermissibleCvssV3Score.hashCode());
        result = result * 59 + (this.exclusions == null ? 43 : this.exclusions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maxPermissibleCvssV2Score")
        private Float maxPermissibleCvssV2Score;
        @JsonProperty(value="maxPermissibleCvssV3Score")
        private Float maxPermissibleCvssV3Score;
        @JsonProperty(value="exclusions")
        private List<String> exclusions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maxPermissibleCvssV2Score(Float maxPermissibleCvssV2Score) {
            this.maxPermissibleCvssV2Score = maxPermissibleCvssV2Score;
            this.__explicitlySet__.add("maxPermissibleCvssV2Score");
            return this;
        }

        public Builder maxPermissibleCvssV3Score(Float maxPermissibleCvssV3Score) {
            this.maxPermissibleCvssV3Score = maxPermissibleCvssV3Score;
            this.__explicitlySet__.add("maxPermissibleCvssV3Score");
            return this;
        }

        public Builder exclusions(List<String> exclusions) {
            this.exclusions = exclusions;
            this.__explicitlySet__.add("exclusions");
            return this;
        }

        public VulnerabilityAuditConfiguration build() {
            VulnerabilityAuditConfiguration model = new VulnerabilityAuditConfiguration(this.maxPermissibleCvssV2Score, this.maxPermissibleCvssV3Score, this.exclusions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VulnerabilityAuditConfiguration model) {
            if (model.wasPropertyExplicitlySet("maxPermissibleCvssV2Score")) {
                this.maxPermissibleCvssV2Score(model.getMaxPermissibleCvssV2Score());
            }
            if (model.wasPropertyExplicitlySet("maxPermissibleCvssV3Score")) {
                this.maxPermissibleCvssV3Score(model.getMaxPermissibleCvssV3Score());
            }
            if (model.wasPropertyExplicitlySet("exclusions")) {
                this.exclusions(model.getExclusions());
            }
            return this;
        }
    }
}

