/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.util.Utils;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.modules.versioning.history.LinkButton;
import org.netbeans.modules.versioning.ui.history.Bundle;
import org.netbeans.modules.versioning.ui.history.History;
import org.netbeans.modules.versioning.ui.history.HistoryDiffView;
import org.netbeans.modules.versioning.ui.history.HistoryEntry;
import org.netbeans.modules.versioning.ui.history.HistoryFileView;
import org.netbeans.modules.versioning.ui.history.HistoryRootNode;
import org.netbeans.modules.versioning.ui.history.HistorySettings;
import org.netbeans.modules.versioning.ui.history.HistoryUtils;
import org.netbeans.modules.versioning.ui.history.RevisionNode;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.swing.etable.QuickFilter;
import org.openide.awt.UndoRedo;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public final class HistoryComponent
extends JPanel
implements MultiViewElement,
HelpCtx.Provider,
PropertyChangeListener {
    private HistoryFileView masterView;
    static final String PREFERRED_ID = "text.history";
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private Toolbar toolBar;
    private EmptyToolbar emptyToolbar;
    private HistoryDiffView diffView;
    private FileObject[] files;
    private final InstanceContent activatedNodesContent;
    private final ProxyLookup lookup;
    private Lookup context;
    private VCSSystemProvider.VersioningSystem versioningSystem;
    private MultiViewElementCallback callback;
    private JSplitPane splitPane;
    private NoContentPanel noContentPanel;
    private final Object FILE_LOCK = new Object();
    private final Object TOOLBAR_LOCK = new Object();
    private final Map<FileObject, FileChangeListener> listeners = new HashMap<FileObject, FileChangeListener>(1);
    private boolean hasLocalHistory;
    private boolean lastDifference = false;
    private boolean firstDifference = true;

    public HistoryComponent() {
        this.activatedNodesContent = new InstanceContent();
        this.lookup = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.activatedNodesContent)});
        this.init();
    }

    public HistoryComponent(VCSFileProxy ... files) {
        this.activatedNodesContent = new InstanceContent();
        this.lookup = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.activatedNodesContent)});
        this.init();
        if (files != null && files.length > 0) {
            this.initFiles(files);
        }
        this.resetUI();
    }

    public HistoryComponent(Lookup context) {
        this.context = context;
        this.activatedNodesContent = new InstanceContent();
        this.lookup = context != null ? new ProxyLookup(new Lookup[]{context, new AbstractLookup((AbstractLookup.Content)this.activatedNodesContent)}) : new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.activatedNodesContent)});
        this.init();
        this.initFromContext();
    }

    private void init() {
        this.initComponents();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        Utils.addPropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initFromContext() {
        if (this.context == null) {
            return;
        }
        Object object = this.FILE_LOCK;
        synchronized (object) {
            DataObject dataObject = (DataObject)this.context.lookup(DataObject.class);
            LinkedList<VCSFileProxy> filesList = new LinkedList<VCSFileProxy>();
            if (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            if (dataObject != null) {
                Set daoFiles = dataObject.files();
                Collection<VCSFileProxy> doFiles = this.toFileCollection(daoFiles);
                if (this.files != null && this.files.length > 0) {
                    HashSet<FileObject> s = new HashSet<FileObject>(Arrays.asList(this.files));
                    boolean changed = false;
                    for (FileObject fo : daoFiles) {
                        if (s.contains(fo)) continue;
                        changed = true;
                        break;
                    }
                    if (!changed) {
                        this.registerFileListeners();
                        return;
                    }
                }
                filesList.addAll(doFiles);
            }
            this.initFiles(filesList.toArray(new VCSFileProxy[0]));
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                HistoryComponent.this.resetUI();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initFiles(VCSFileProxy[] files) {
        Object object = this.FILE_LOCK;
        synchronized (object) {
            ArrayList<FileObject> l = new ArrayList<FileObject>(files.length);
            this.unregisterFileListeners();
            for (VCSFileProxy proxy : files) {
                FileObject fo = proxy.toFileObject();
                if (fo == null) continue;
                l.add(fo);
            }
            this.files = l.toArray(new FileObject[0]);
            this.registerFileListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFileListeners() {
        Map<FileObject, FileChangeListener> map = this.listeners;
        synchronized (map) {
            if (!this.listeners.isEmpty()) {
                Iterator<Map.Entry<FileObject, FileChangeListener>> it = this.listeners.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<FileObject, FileChangeListener> e = it.next();
                    e.getKey().removeFileChangeListener(e.getValue());
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFileListeners() {
        FileObject[] registerFiles = this.getFiles();
        Map<FileObject, FileChangeListener> map = this.listeners;
        synchronized (map) {
            if (!this.listeners.isEmpty()) {
                return;
            }
            for (FileObject fo : registerFiles) {
                FileChangeListener listener = new FileChangeListener(){

                    public void fileRenamed(FileRenameEvent fe) {
                        HistoryComponent.this.initFromContext();
                    }

                    public void fileDeleted(FileEvent fe) {
                        HistoryComponent.this.initFromContext();
                    }

                    public void fileFolderCreated(FileEvent fe) {
                    }

                    public void fileDataCreated(FileEvent fe) {
                    }

                    public void fileChanged(FileEvent fe) {
                    }

                    public void fileAttributeChanged(FileAttributeEvent fe) {
                    }
                };
                this.listeners.put(fo, listener);
                fo.addFileChangeListener(listener);
            }
        }
    }

    private Collection<VCSFileProxy> toFileCollection(Collection<? extends FileObject> fileObjects) {
        HashSet<VCSFileProxy> ret = new HashSet<VCSFileProxy>(fileObjects.size());
        for (FileObject fileObject : fileObjects) {
            ret.add(VCSFileProxy.createFileProxy((FileObject)fileObject));
        }
        ret.remove(null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUI() {
        if (this.hasFiles()) {
            FileObject fo = this.getFile();
            this.versioningSystem = this.hasFiles() ? this.getOwner(fo) : null;
            History.LOG.log(Level.FINE, "owner of {0} is {1}", new Object[]{fo, this.versioningSystem != null ? this.versioningSystem.getDisplayName() : null});
            if (!this.hasHistory()) {
                this.noHistoryAvailable();
                return;
            }
        } else {
            this.noHistoryAvailable();
            return;
        }
        if (this.noContentPanel != null) {
            this.remove((Component)this.noContentPanel);
        }
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setDividerLocation(150);
            this.splitPane.setOrientation(0);
            this.splitPane.setOneTouchExpandable(true);
            this.add((Component)this.splitPane, "Center");
        }
        boolean hadToolbar = false;
        Object object = this.TOOLBAR_LOCK;
        synchronized (object) {
            if (this.toolBar == null) {
                this.toolBar = this.getToolbar();
            }
        }
        if (hadToolbar) {
            this.toolBar.setup(this.versioningSystem);
        }
        this.masterView = new HistoryFileView(this.versioningSystem, History.getInstance().getLocalHistory(this.getFile()), this);
        this.diffView = new HistoryDiffView(this);
        this.masterView.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this.diffView);
        this.masterView.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){
            private Node[] activatedNodes;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Node[] newSelection = (Node[])evt.getNewValue();
                    if (this.activatedNodes != null) {
                        for (Node n : this.activatedNodes) {
                            HistoryComponent.this.activatedNodesContent.remove((Object)n);
                        }
                    }
                    for (Node n : this.activatedNodes = newSelection) {
                        HistoryComponent.this.activatedNodesContent.add((Object)n);
                    }
                    if (newSelection != null) {
                        HistoryComponent.this.getToolbar().modeCombo.setEnabled(newSelection.length == 1);
                        HistoryComponent.this.getToolbar().modeLabel.setEnabled(newSelection.length == 1);
                    }
                }
            }
        });
        this.splitPane.setTopComponent(this.masterView.getPanel());
        this.splitPane.setBottomComponent(this.diffView.getPanel());
        this.masterView.refresh();
    }

    private VCSSystemProvider.VersioningSystem getOwner(FileObject fileObject) {
        return Utils.getOwner((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fileObject));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FileObject fo;
        VCSSystemProvider.VersioningSystem vs;
        if ("null VCS.VersionedFilesChanged".equals(evt.getPropertyName()) && this.hasFiles() && (this.versioningSystem != (vs = this.getOwner(fo = this.getFile())) || this.hasLocalHistory != (History.getHistoryProvider(History.getInstance().getLocalHistory(fo)) != null))) {
            this.versioningSystem = vs;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoryComponent.this.resetUI();
                }
            });
        }
    }

    HistoryEntry getParentEntry(HistoryEntry entry) {
        return this.masterView.getParentEntry(entry);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    void setDiffView(JComponent currentDiffView) {
        this.delegatingUndoRedo.setDiffView(currentDiffView);
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.hasHistory()) {
            return this.getToolbar();
        }
        if (this.emptyToolbar == null) {
            this.emptyToolbar = new EmptyToolbar();
        }
        return this.emptyToolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Toolbar getToolbar() {
        Object object = this.TOOLBAR_LOCK;
        synchronized (object) {
            if (this.toolBar == null) {
                this.toolBar = new Toolbar(this.versioningSystem);
            }
            return this.toolBar;
        }
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public CloseOperationState canCloseElement() {
        if (!this.hasFiles()) {
            return CloseOperationState.STATE_OK;
        }
        FileObject fo = this.getFile();
        if (fo != null) {
            DataObject dataObject;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                if (fo.isValid()) {
                    History.LOG.log(Level.WARNING, fo.getPath(), ex);
                } else {
                    History.LOG.log(Level.INFO, "could''t find dataobject for file " + fo.getPath(), ex);
                }
                return CloseOperationState.STATE_OK;
            }
            if (dataObject != null && dataObject.isModified()) {
                AbstractAction save = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SaveCookie sc = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                        if (sc != null) {
                            try {
                                sc.save();
                            }
                            catch (IOException ex) {
                                History.LOG.log(Level.WARNING, null, ex);
                            }
                        }
                    }
                };
                save.putValue("LongDescription", Bundle.MSG_SaveModified(dataObject.getPrimaryFile().getNameExt()));
                return MultiViewFactory.createUnsafeCloseState((String)"editor", (Action)save, null);
            }
        }
        return CloseOperationState.STATE_OK;
    }

    String getActiveFilterValue() {
        return this.getToolbar().containsField.isVisible() ? this.getToolbar().containsField.getText() : null;
    }

    public void componentClosed() {
        Utils.removePropertyChangeListener((PropertyChangeListener)this);
        this.unregisterFileListeners();
        if (this.masterView != null) {
            this.masterView.close();
        }
        if (this.diffView != null) {
            this.diffView.componentClosed();
        }
    }

    public void componentOpened() {
        this.initFromContext();
    }

    public void componentActivated() {
        if (this.masterView != null) {
            this.masterView.requestActive();
        }
    }

    public Action[] getActions() {
        Action[] retValue = this.callback != null ? this.callback.createDefaultActions() : new Action[]{};
        return retValue;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void componentShowing() {
    }

    public void componentHidden() {
        if (this.masterView != null) {
            this.masterView.hidden();
        }
    }

    public void componentDeactivated() {
    }

    Node[] getSelectedNodes() {
        return this.masterView.getExplorerManager().getSelectedNodes();
    }

    private boolean hasFiles() {
        FileObject[] fs = this.getFiles();
        return fs != null && fs.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileObject[] getFiles() {
        Object object = this.FILE_LOCK;
        synchronized (object) {
            return this.files != null ? Arrays.copyOf(this.files, this.files.length) : null;
        }
    }

    private FileObject getFile() {
        return this.getFiles()[0];
    }

    private void noHistoryAvailable() throws MissingResourceException {
        if (this.noContentPanel == null) {
            this.noContentPanel = new NoContentPanel(NbBundle.getMessage(HistoryComponent.class, (String)"MSG_NO_HISTORY"));
        }
        this.add((Component)this.noContentPanel);
    }

    private boolean hasHistory() {
        if (this.hasFiles()) {
            this.hasLocalHistory = History.getHistoryProvider(History.getInstance().getLocalHistory(this.getFile())) != null;
            return this.hasFiles() && (this.hasLocalHistory || History.getHistoryProvider(this.versioningSystem) != null);
        }
        return false;
    }

    CompareMode getMode() {
        return (CompareMode)((Object)this.getToolbar().modeCombo.getSelectedItem());
    }

    void disableNavigationButtons() {
        this.getToolbar().prevButton.setEnabled(false);
        this.getToolbar().nextButton.setEnabled(false);
    }

    void refreshNavigationButtons(int currentDifference, int diffCount) {
        this.firstDifference = currentDifference <= 0;
        boolean bl = this.lastDifference = currentDifference >= diffCount - 1;
        if (this.masterView.isSingleSelection()) {
            this.getToolbar().prevButton.setEnabled(!this.firstDifference || !this.masterView.isFirstRow());
            this.getToolbar().nextButton.setEnabled(!this.lastDifference || !this.masterView.isLastRow());
        } else {
            this.getToolbar().prevButton.setEnabled(currentDifference > 0);
            this.getToolbar().nextButton.setEnabled(currentDifference < diffCount - 1);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.localhistory.ui.view.LHHistoryTab");
    }

    private String getFilteredRendererValue(String value) {
        String t;
        String contains = this.getToolbar().containsField.getText();
        if (contains == null || "".equals(contains)) {
            return HistoryUtils.escapeForHTMLLabel(value);
        }
        StringBuilder sb = new StringBuilder();
        int startIdx = 0;
        int endIdx = value.indexOf(contains);
        if (endIdx < 0) {
            return HistoryUtils.escapeForHTMLLabel(value);
        }
        while (endIdx > -1) {
            t = value.substring(startIdx, endIdx);
            sb.append(HistoryUtils.escapeForHTMLLabel(t));
            sb.append("<b>");
            sb.append(HistoryUtils.escapeForHTMLLabel(contains));
            sb.append("</b>");
            startIdx = endIdx + contains.length();
            endIdx = value.indexOf(contains, startIdx);
        }
        if (startIdx < value.length()) {
            t = value.substring(startIdx);
            sb.append(HistoryUtils.escapeForHTMLLabel(t));
        }
        return sb.toString();
    }

    private class Toolbar
    extends JToolBar
    implements ActionListener {
        private final JButton nextButton;
        private final JButton prevButton;
        private final JButton refreshButton;
        private final JButton settingsButton;
        private JLabel modeLabel;
        private JLabel filterLabel;
        private JComboBox filterCombo;
        private JComboBox modeCombo;
        private JLabel containsLabel;
        private JTextField containsField;
        private final ShowHistoryAction showHistoryAction;
        private final LinkButton searchHistoryButton;
        private final JToolBar.Separator separator1;
        private final JToolBar.Separator separator2;
        private final JToolBar.Separator separator3;
        private boolean ignoreModeChange = false;

        private Toolbar(VCSSystemProvider.VersioningSystem vs) {
            this.setOpaque(false);
            this.setFloatable(false);
            this.containsLabel = new JLabel(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_Contains"));
            this.containsLabel.setVisible(false);
            this.containsField = new JTextField();
            this.containsField.setPreferredSize(new Dimension(150, this.containsField.getPreferredSize().height));
            this.containsField.setMaximumSize(new Dimension(150, this.containsField.getPreferredSize().height));
            this.containsField.setMinimumSize(new Dimension(150, this.containsField.getPreferredSize().height));
            this.containsField.getDocument().addDocumentListener(new ContainsListener());
            this.containsField.setVisible(false);
            this.modeLabel = new JLabel(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_CompareMode"));
            this.modeCombo = new ValueSizedCombo();
            this.modeCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{CompareMode.TOCURRENT, CompareMode.TOPARENT}));
            this.modeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Toolbar.this.onModeChange();
                    }
                }
            });
            this.filterLabel = new JLabel(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_Filter"));
            this.filterCombo = new ValueSizedCombo();
            this.filterCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value instanceof Filter) {
                        return super.getListCellRendererComponent((JList<?>)list, ((Filter)value).getDisplayName(), index, isSelected, cellHasFocus);
                    }
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            });
            this.filterCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Toolbar.this.onFilterChange();
                    }
                }
            });
            this.nextButton = new JButton(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/ui/resources/icons/diff-next.png")));
            this.nextButton.addActionListener(this);
            this.nextButton.setEnabled(false);
            this.nextButton.setToolTipText(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_NextDiff"));
            this.prevButton = new JButton(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/ui/resources/icons/diff-prev.png")));
            this.prevButton.addActionListener(this);
            this.prevButton.setEnabled(false);
            this.prevButton.setToolTipText(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_PrevDiff"));
            this.refreshButton = new JButton(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/ui/resources/icons/refresh.png")));
            this.refreshButton.addActionListener(this);
            this.refreshButton.setToolTipText(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_Refresh"));
            this.settingsButton = new JButton(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/ui/resources/icons/options.png")));
            this.settingsButton.addActionListener(this);
            this.settingsButton.setToolTipText(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_Options"));
            this.showHistoryAction = new ShowHistoryAction(vs);
            this.searchHistoryButton = new LinkButton();
            this.searchHistoryButton.addActionListener((ActionListener)this.showHistoryAction);
            this.separator1 = new JToolBar.Separator();
            this.separator1.setOrientation(1);
            this.separator2 = new JToolBar.Separator();
            this.separator2.setOrientation(1);
            this.separator3 = new JToolBar.Separator();
            this.separator3.setOrientation(1);
            this.setup(vs);
            this.nextButton.setBorder(new EmptyBorder(0, 5, 0, 5));
            this.prevButton.setBorder(new EmptyBorder(0, 5, 0, 5));
            this.refreshButton.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.filterLabel.setBorder(new EmptyBorder(0, 15, 0, 5));
            this.modeLabel.setBorder(new EmptyBorder(0, 15, 0, 5));
            this.containsLabel.setBorder(new EmptyBorder(0, 5, 0, 10));
            this.settingsButton.setBorder(new EmptyBorder(0, 5, 0, 10));
            this.setLayout(new BoxLayout(this, 2));
            this.add(this.nextButton);
            this.add(this.prevButton);
            this.add(this.separator1);
            this.add(this.refreshButton);
            this.add(this.separator2);
            this.add(this.filterLabel);
            this.add(this.filterCombo);
            this.add(this.containsLabel);
            this.add(this.containsField);
            this.add(this.modeLabel);
            this.add(this.modeCombo);
            this.add(this.separator3);
            this.add(this.settingsButton);
            JPanel placeholder = new JPanel();
            placeholder.setOpaque(false);
            this.add(placeholder);
            this.add((Component)this.searchHistoryButton);
        }

        void setup(VCSSystemProvider.VersioningSystem vs) {
            boolean visible;
            boolean bl = visible = vs != null && vs.getVCSHistoryProvider() != null;
            if (visible) {
                this.showHistoryAction.vs = vs;
                this.searchHistoryButton.setText(NbBundle.getMessage(this.getClass(), (String)"LBL_ShowVersioningHistory", (Object[])new Object[]{vs.getDisplayName()}));
                Filter[] filters = new Filter[]{new AllFilter(), new VCSFilter(vs.getDisplayName()), new LHFilter(), new ByUserFilter(), new ByMsgFilter()};
                this.filterCombo.setModel(new DefaultComboBoxModel<Filter>(filters));
                this.setMode((Filter)this.filterCombo.getSelectedItem());
            }
            this.filterCombo.setVisible(visible);
            this.filterLabel.setVisible(visible);
            this.searchHistoryButton.setVisible(visible);
            this.refreshButton.setVisible(visible);
            this.settingsButton.setVisible(visible);
            this.separator1.setVisible(visible);
            this.separator2.setVisible(visible);
        }

        private void onFilterChange() {
            Filter filter = (Filter)((HistoryComponent)HistoryComponent.this).getToolbar().filterCombo.getSelectedItem();
            this.setMode(filter);
            ((HistoryComponent)HistoryComponent.this).getToolbar().containsLabel.setVisible(filter instanceof ByUserFilter || filter instanceof ByMsgFilter);
            ((HistoryComponent)HistoryComponent.this).getToolbar().containsField.setVisible(filter instanceof ByUserFilter || filter instanceof ByMsgFilter);
            HistoryComponent.this.masterView.setFilter(filter);
            ((HistoryComponent)HistoryComponent.this).getToolbar().containsField.setText("");
            ((HistoryComponent)HistoryComponent.this).getToolbar().containsField.requestFocus();
        }

        private void onModeChange() {
            if (this.ignoreModeChange) {
                return;
            }
            Filter filter = (Filter)((HistoryComponent)HistoryComponent.this).getToolbar().filterCombo.getSelectedItem();
            this.storeMode(filter);
            HistoryComponent.this.diffView.modeChanged();
            if (HistoryComponent.this.masterView != null) {
                HistoryComponent.this.masterView.requestActive();
            }
        }

        private void storeMode(Filter filter) {
            if (filter instanceof AllFilter) {
                HistorySettings.getInstance().setAllMode(((CompareMode)((Object)((HistoryComponent)HistoryComponent.this).getToolbar().modeCombo.getSelectedItem())).name());
                HistorySettings.getInstance().setVCSMode(((CompareMode)((Object)((HistoryComponent)HistoryComponent.this).getToolbar().modeCombo.getSelectedItem())).name());
                HistorySettings.getInstance().setLHMode(((CompareMode)((Object)((HistoryComponent)HistoryComponent.this).getToolbar().modeCombo.getSelectedItem())).name());
            } else if (filter instanceof VCSFilter) {
                HistorySettings.getInstance().setVCSMode(((CompareMode)((Object)((HistoryComponent)HistoryComponent.this).getToolbar().modeCombo.getSelectedItem())).name());
            } else if (filter instanceof LHFilter) {
                HistorySettings.getInstance().setLHMode(((CompareMode)((Object)((HistoryComponent)HistoryComponent.this).getToolbar().modeCombo.getSelectedItem())).name());
            }
        }

        private void setMode(Filter filter) {
            CompareMode mode;
            if (filter instanceof AllFilter) {
                mode = CompareMode.valueOf(HistorySettings.getInstance().getAllMode(CompareMode.TOCURRENT.name()));
            } else if (filter instanceof VCSFilter) {
                mode = CompareMode.valueOf(HistorySettings.getInstance().getVCSMode(CompareMode.TOCURRENT.name()));
            } else if (filter instanceof LHFilter) {
                mode = CompareMode.valueOf(HistorySettings.getInstance().getLHMode(CompareMode.TOCURRENT.name()));
            } else {
                return;
            }
            this.ignoreModeChange = true;
            try {
                this.modeCombo.setSelectedItem((Object)mode);
            }
            finally {
                this.ignoreModeChange = false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ((HistoryComponent)HistoryComponent.this).getToolbar().nextButton) {
                if (HistoryComponent.this.lastDifference) {
                    HistoryComponent.this.masterView.selectNextEntry();
                } else {
                    HistoryComponent.this.diffView.onNextButton();
                }
            } else if (e.getSource() == ((HistoryComponent)HistoryComponent.this).getToolbar().prevButton) {
                if (HistoryComponent.this.firstDifference) {
                    HistoryComponent.this.diffView.onSelectionLastDifference();
                    HistoryComponent.this.masterView.selectPrevEntry();
                } else {
                    HistoryComponent.this.diffView.onPrevButton();
                }
            } else if (e.getSource() == ((HistoryComponent)HistoryComponent.this).getToolbar().refreshButton) {
                HistoryComponent.this.masterView.refresh();
            } else if (e.getSource() == ((HistoryComponent)HistoryComponent.this).getToolbar().settingsButton) {
                OptionsDisplayer.getDefault().open("Team/Versioning/History");
            }
        }

        private class ValueSizedCombo
        extends JComboBox {
            private ValueSizedCombo() {
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.getComboWidth(), super.getPreferredSize().height);
            }

            private Object[] getValues() {
                Object[] ret = new Object[this.getModel().getSize()];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = this.getModel().getElementAt(i);
                }
                return ret;
            }

            private int getComboWidth() {
                Object[] values = this.getValues();
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int ret = 130;
                for (Object value : values) {
                    int width = fm.stringWidth(value.toString()) + 60;
                    if (width > 350) {
                        return 350;
                    }
                    if (width <= ret) continue;
                    ret = width;
                }
                return ret;
            }
        }

        private class ShowHistoryAction
        extends AbstractAction {
            private VCSSystemProvider.VersioningSystem vs;
            private final Set<String> forPaths = new HashSet<String>(1);
            private Action delegate;

            public ShowHistoryAction(VCSSystemProvider.VersioningSystem vs) {
                this.vs = vs;
                this.init();
            }

            private synchronized void init() {
                VCSHistoryProvider provider;
                VCSHistoryProvider vCSHistoryProvider = provider = this.vs != null ? this.vs.getVCSHistoryProvider() : null;
                if (provider == null) {
                    return;
                }
                FileObject[] fs = HistoryComponent.this.getFiles();
                this.delegate = provider.createShowHistoryAction(History.toProxies(fs));
                if (this.delegate == null) {
                    return;
                }
                this.putValue("Name", this.delegate.getValue("Name"));
                this.forPaths.clear();
                for (FileObject fo : fs) {
                    this.forPaths.add(fo.getPath());
                }
            }

            @Override
            public void actionPerformed(final ActionEvent e) {
                History.getInstance().getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        for (FileObject fo : HistoryComponent.this.getFiles()) {
                            if (ShowHistoryAction.this.forPaths.contains(fo.getPath())) continue;
                            ShowHistoryAction.this.init();
                            break;
                        }
                        assert (ShowHistoryAction.this.delegate != null);
                        if (ShowHistoryAction.this.delegate != null) {
                            ShowHistoryAction.this.delegate.actionPerformed(e);
                        }
                    }
                });
            }
        }
    }

    private class EmptyToolbar
    extends JToolBar {
        private EmptyToolbar() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setOpaque(false);
            this.setFloatable(false);
        }
    }

    static enum CompareMode {
        TOPARENT(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_DiffToParent")),
        TOCURRENT(NbBundle.getMessage(HistoryComponent.class, (String)"LBL_DiffToCurrent"));

        private final String displayName;

        private CompareMode(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private class ContainsListener
    implements DocumentListener,
    ActionListener {
        private final Timer t = new Timer(300, this);

        public ContainsListener() {
            this.t.setRepeats(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.t.start();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.t.start();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.t.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryComponent.this.masterView.fireFilterChanged();
        }
    }

    private class ByMsgFilter
    extends Filter {
        private ByMsgFilter() {
        }

        @Override
        public boolean filtersProperty(Node.Property property) {
            return property instanceof RevisionNode.MessageProperty;
        }

        public boolean accept(Object value) {
            if (HistoryRootNode.isLoadNext(value) || HistoryRootNode.isWait(value)) {
                return true;
            }
            String byMsg = HistoryComponent.this.getToolbar().containsField.getText();
            if (byMsg == null || "".equals(byMsg)) {
                return true;
            }
            HistoryEntry e = this.getEntry(value);
            if (e != null) {
                String msg = e.getMessage();
                return msg != null && msg.toLowerCase().contains(byMsg.toLowerCase());
            }
            return true;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(HistoryComponent.class, (String)"LBL_ByMsgFilter");
        }

        @Override
        public String getRendererValue(String value) {
            return HistoryComponent.this.getFilteredRendererValue(value);
        }
    }

    private class ByUserFilter
    extends Filter {
        private ByUserFilter() {
        }

        @Override
        public boolean filtersProperty(Node.Property property) {
            return property instanceof RevisionNode.UserProperty;
        }

        public boolean accept(Object value) {
            if (HistoryRootNode.isLoadNext(value) || HistoryRootNode.isWait(value)) {
                return true;
            }
            String byUser = HistoryComponent.this.getToolbar().containsField.getText();
            if (byUser == null || "".equals(byUser)) {
                return true;
            }
            HistoryEntry e = this.getEntry(value);
            if (e != null) {
                String user = e.getUsernameShort();
                return user.toLowerCase().contains(byUser.toLowerCase());
            }
            return true;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(HistoryComponent.class, (String)"LBL_ByUserFilter");
        }

        @Override
        public String getRendererValue(String value) {
            return HistoryComponent.this.getFilteredRendererValue(value);
        }
    }

    private class LHFilter
    extends Filter {
        private LHFilter() {
        }

        public boolean accept(Object value) {
            HistoryEntry e = this.getEntry(value);
            return e != null && e.isLocalHistory();
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(HistoryComponent.class, (String)"LBL_LHRevisionsFilter");
        }
    }

    private class VCSFilter
    extends Filter {
        private final String vcsName;

        public VCSFilter(String vscName) {
            this.vcsName = vscName;
        }

        public boolean accept(Object value) {
            if (HistoryRootNode.isLoadNext(value) || HistoryRootNode.isWait(value)) {
                return true;
            }
            HistoryEntry e = this.getEntry(value);
            return e != null && !e.isLocalHistory();
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(HistoryComponent.class, (String)"LBL_VCSRevisionsFilter", (Object[])new Object[]{this.vcsName});
        }
    }

    private class AllFilter
    extends Filter {
        private AllFilter() {
        }

        public boolean accept(Object value) {
            return true;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(HistoryComponent.class, (String)"LBL_AllRevisionsFilter");
        }
    }

    static abstract class Filter
    implements QuickFilter {
        Filter() {
        }

        public boolean filtersProperty(Node.Property property) {
            return false;
        }

        public abstract String getDisplayName();

        protected HistoryEntry getEntry(Object value) {
            if (value instanceof Node) {
                return this.getHistoryEntry((Node)value);
            }
            return null;
        }

        private HistoryEntry getHistoryEntry(Node node) {
            HistoryEntry entry = (HistoryEntry)node.getLookup().lookup(HistoryEntry.class);
            if (entry != null) {
                return entry;
            }
            Node[] nodes = node.getChildren().getNodes();
            return nodes != null && nodes.length > 0 ? this.getHistoryEntry(nodes[0]) : null;
        }

        public String getRendererValue(String value) {
            return HistoryUtils.escapeForHTMLLabel(value);
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

