/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php;

import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.php.delete.PhpDeleteRefactoringPlugin;
import org.netbeans.modules.refactoring.php.delete.SafeDeleteSupport;
import org.netbeans.modules.refactoring.php.findusages.PhpWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.php.rename.PhpRenameRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.util.Lookup;

public class PhpRefactoringsFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        if (refactoring instanceof WhereUsedQuery) {
            return this.createFindUsages((WhereUsedQuery)refactoring);
        }
        if (refactoring instanceof RenameRefactoring) {
            return this.createRename((RenameRefactoring)refactoring);
        }
        if (refactoring instanceof SafeDeleteRefactoring) {
            return this.createDelete((SafeDeleteRefactoring)refactoring);
        }
        return null;
    }

    private RefactoringPlugin createFindUsages(WhereUsedQuery refactoring) {
        Lookup look = refactoring.getRefactoringSource();
        WhereUsedSupport handle = (WhereUsedSupport)look.lookup(WhereUsedSupport.class);
        return handle != null ? new PhpWhereUsedQueryPlugin((AbstractRefactoring)refactoring) : null;
    }

    private RefactoringPlugin createRename(RenameRefactoring refactoring) {
        Lookup look = refactoring.getRefactoringSource();
        WhereUsedSupport handle = (WhereUsedSupport)look.lookup(WhereUsedSupport.class);
        return handle != null ? new PhpRenameRefactoringPlugin(refactoring) : null;
    }

    private RefactoringPlugin createDelete(SafeDeleteRefactoring refactoring) {
        Lookup look = refactoring.getRefactoringSource();
        SafeDeleteSupport handle = (SafeDeleteSupport)look.lookup(SafeDeleteSupport.class);
        return handle != null ? new PhpDeleteRefactoringPlugin(refactoring) : null;
    }
}

