/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.beans.BeanPanelUI;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.ClassPattern;
import org.netbeans.modules.beans.PatternAnalyser;

public class BeanScanningTask
implements CancellableTask<CompilationInfo> {
    private BeanPanelUI ui;
    private volatile boolean canceled;

    public BeanScanningTask(BeanPanelUI ui) {
        this.ui = ui;
    }

    public void cancel() {
        this.canceled = true;
    }

    public void run(CompilationInfo info) throws Exception {
        this.canceled = false;
        CompilationUnitTree cuTree = info.getCompilationUnit();
        List<? extends Tree> typeDecls = cuTree.getTypeDecls();
        ArrayList<Element> elements = new ArrayList<Element>(typeDecls.size());
        TreePath cuPath = new TreePath(cuTree);
        for (Tree tree : typeDecls) {
            TreePath p = new TreePath(cuPath, tree);
            Element e = info.getTrees().getElement(p);
            if (e == null) continue;
            elements.add(e);
        }
        ArrayList<ClassPattern> classPatterns = new ArrayList<ClassPattern>(elements.size());
        for (Element e : elements) {
            if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE) continue;
            PatternAnalyser pa = new PatternAnalyser(info.getFileObject(), this.ui);
            pa.analyzeAll(info, (TypeElement)e);
            ClassPattern cp = new ClassPattern(pa, e.asType(), BeanUtils.nameAsString(e));
            classPatterns.add(cp);
        }
        PatternAnalyser patternAnalyser = new PatternAnalyser(info.getFileObject(), this.ui, classPatterns);
        if (!this.canceled) {
            this.ui.refresh(new ClassPattern(patternAnalyser));
        }
    }
}

