/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.netbeans.modules.svg.BackgroundMode;
import org.netbeans.modules.svg.Utils;

public class BackgroundIcon
implements Icon {
    private final BackgroundMode bgMode;
    private final Color defaultColor;

    public BackgroundIcon(BackgroundMode bgMode, Color defaultColor) {
        this.bgMode = bgMode;
        this.defaultColor = defaultColor;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        switch (this.bgMode) {
            case BLACK: {
                g2d.setColor(Color.BLACK);
                g2d.fillRect(x, y, width, height);
                break;
            }
            case WHITE: {
                g2d.setColor(Color.WHITE);
                g2d.fillRect(x, y, width, height);
                break;
            }
            case TRANSPARENT: 
            case DARK_TRANSPARENT: {
                Utils.drawSmallChestTilePattern(g2d, x, y, width, height, this.bgMode == BackgroundMode.DARK_TRANSPARENT);
                break;
            }
            case DEFAULT: {
                g2d.setColor(this.defaultColor);
                g2d.fillRect(x, y, width, height);
            }
        }
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }
}

