/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.From;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;

public class FromNode
implements From {
    List<JoinTable> _tableList;

    public FromNode() {
    }

    public FromNode(List tableList) {
        this._tableList = tableList;
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        String res = "";
        if (this._tableList.size() > 0) {
            res = " FROM " + ((JoinTableNode)this._tableList.get(0)).genText(quoter, true);
            for (int i = 1; i < this._tableList.size(); ++i) {
                res = res + ((JoinTableNode)this._tableList.get(i)).genText(quoter);
            }
        }
        return res;
    }

    public String toString() {
        String res = "FROM:";
        for (int i = 0; i < this._tableList.size(); ++i) {
            res = res + ((JoinTableNode)this._tableList.get(i)).toString() + "";
        }
        return res;
    }

    @Override
    public List getTableList() {
        return this._tableList;
    }

    List<Table> getTables() {
        ArrayList<Table> tableRefs = new ArrayList<Table>();
        for (int i = 0; i < this._tableList.size(); ++i) {
            tableRefs.add(((JoinTableNode)this._tableList.get(i)).getTable());
        }
        return tableRefs;
    }

    @Override
    public String getPreviousTableFullName() {
        JoinTableNode jt = (JoinTableNode)this._tableList.get(this._tableList.size() - 2);
        return jt.getTable().getFullTableName();
    }

    @Override
    public Table findTable(String tableSpec) {
        for (int i = 0; i < this._tableList.size(); ++i) {
            JoinTableNode jt = (JoinTableNode)this._tableList.get(i);
            if (!jt.getTableSpec().equals(tableSpec)) continue;
            return jt.getTable();
        }
        return null;
    }

    @Override
    public JoinTable findJoinTable(String table1, String column1, String table2, String column2) {
        List<JoinTable> tableList = this._tableList;
        for (int i = 0; i < tableList.size(); ++i) {
            JoinTableNode jt = (JoinTableNode)tableList.get(i);
            Expression cond = jt.getExpression();
            if (!(cond instanceof Predicate)) continue;
            Predicate pred = (Predicate)cond;
            Value val1 = pred.getVal1();
            Value val2 = pred.getVal2();
            if (!(val1 instanceof ColumnNode) || !(val2 instanceof ColumnNode)) continue;
            ColumnNode col1 = (ColumnNode)val1;
            ColumnNode col2 = (ColumnNode)val2;
            if ((!col1.getTableSpec().equals(table1) || !col1.getColumnName().equals(column1) || !col2.getTableSpec().equals(table2) || !col2.getColumnName().equals(column2)) && (!col2.getTableSpec().equals(table1) || !col2.getColumnName().equals(column1) || !col1.getTableSpec().equals(table2) || !col1.getColumnName().equals(column2))) continue;
            return jt;
        }
        return null;
    }

    @Override
    public String getFullTableName(String corrName) {
        for (int i = 0; i < this._tableList.size(); ++i) {
            JoinTable jt = this._tableList.get(i);
            String cn = jt.getTableSpec();
            if (cn == null || !cn.equals(corrName)) continue;
            return jt.getFullTableName();
        }
        return null;
    }

    @Override
    public String getTableSpec(String fullTableName) {
        for (int i = 0; i < this._tableList.size(); ++i) {
            JoinTable jt = this._tableList.get(i);
            String cn = jt.getFullTableName();
            if (cn == null || !cn.equals(fullTableName)) continue;
            return jt.getTableSpec();
        }
        return null;
    }

    @Override
    public void addTable(JoinTable jt) {
        this._tableList.add(jt);
    }

    void removeTable(String tableSpec) {
        for (int i = this._tableList.size() - 1; i >= 0; --i) {
            if (!((JoinTableNode)this._tableList.get(i)).getTableSpec().equals(tableSpec)) continue;
            this._tableList.remove(i);
        }
    }

    void renameTableSpec(String oldTableSpec, String corrName) {
        for (int i = 0; i < this._tableList.size(); ++i) {
            JoinTableNode jt = (JoinTableNode)this._tableList.get(i);
            jt.renameTableSpec(oldTableSpec, corrName);
        }
    }

    @Override
    public void setTableSpec(String oldTableSpec, String newTableSpec) {
        for (int i = 0; i < this._tableList.size(); ++i) {
            JoinTableNode jt = (JoinTableNode)this._tableList.get(i);
            jt.setTableSpec(oldTableSpec, newTableSpec);
        }
    }

    @Override
    public void getReferencedColumns(Collection columns) {
    }
}

