/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateInstanceConfigurationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateInstanceConfigurationRequest
extends BmcRequest<UpdateInstanceConfigurationDetails> {
    private String instanceConfigurationId;
    private UpdateInstanceConfigurationDetails updateInstanceConfigurationDetails;
    private String opcRetryToken;
    private String ifMatch;

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public UpdateInstanceConfigurationDetails getUpdateInstanceConfigurationDetails() {
        return this.updateInstanceConfigurationDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateInstanceConfigurationDetails getBody$() {
        return this.updateInstanceConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().instanceConfigurationId(this.instanceConfigurationId).updateInstanceConfigurationDetails(this.updateInstanceConfigurationDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConfigurationId=").append(String.valueOf(this.instanceConfigurationId));
        sb.append(",updateInstanceConfigurationDetails=").append(String.valueOf((Object)this.updateInstanceConfigurationDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateInstanceConfigurationRequest)) {
            return false;
        }
        UpdateInstanceConfigurationRequest other = (UpdateInstanceConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConfigurationId, other.instanceConfigurationId) && Objects.equals((Object)this.updateInstanceConfigurationDetails, (Object)other.updateInstanceConfigurationDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConfigurationId == null ? 43 : this.instanceConfigurationId.hashCode());
        result = result * 59 + (this.updateInstanceConfigurationDetails == null ? 43 : this.updateInstanceConfigurationDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConfigurationId = null;
        private UpdateInstanceConfigurationDetails updateInstanceConfigurationDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            return this;
        }

        public Builder updateInstanceConfigurationDetails(UpdateInstanceConfigurationDetails updateInstanceConfigurationDetails) {
            this.updateInstanceConfigurationDetails = updateInstanceConfigurationDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateInstanceConfigurationRequest o) {
            this.instanceConfigurationId(o.getInstanceConfigurationId());
            this.updateInstanceConfigurationDetails(o.getUpdateInstanceConfigurationDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateInstanceConfigurationRequest build() {
            UpdateInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateInstanceConfigurationDetails body) {
            this.updateInstanceConfigurationDetails(body);
            return this;
        }

        public UpdateInstanceConfigurationRequest buildWithoutInvocationCallback() {
            UpdateInstanceConfigurationRequest request = new UpdateInstanceConfigurationRequest();
            request.instanceConfigurationId = this.instanceConfigurationId;
            request.updateInstanceConfigurationDetails = this.updateInstanceConfigurationDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

