/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.io.InputStream;
import org.cybergarage.http.HTTPPacket;
import org.cybergarage.http.HTTPServer;
import org.cybergarage.http.HTTPSocket;
import org.cybergarage.http.HTTPStatus;
import org.cybergarage.util.Debug;

public class HTTPResponse
extends HTTPPacket {
    private int statusCode = 0;

    public HTTPResponse() {
        this.setVersion("1.1");
        this.setContentType("text/html; charset=\"utf-8\"");
        this.setServer(HTTPServer.getName());
        this.setContent("");
    }

    public HTTPResponse(HTTPResponse httpRes) {
        this.set(httpRes);
    }

    public HTTPResponse(InputStream in) {
        super(in);
    }

    public HTTPResponse(HTTPSocket httpSock) {
        this(httpSock.getInputStream());
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public int getStatusCode() {
        if (this.statusCode != 0) {
            return this.statusCode;
        }
        HTTPStatus httpStatus = new HTTPStatus(this.getFirstLine());
        return httpStatus.getStatusCode();
    }

    public boolean isSuccessful() {
        return HTTPStatus.isSuccessful(this.getStatusCode());
    }

    public String getStatusLineString() {
        return "HTTP/" + this.getVersion() + " " + this.getStatusCode() + " " + HTTPStatus.code2String(this.statusCode) + "\r\n";
    }

    public String getHeader() {
        StringBuffer str = new StringBuffer();
        str.append(this.getStatusLineString());
        str.append(this.getHeaderString());
        return str.toString();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getStatusLineString());
        str.append(this.getHeaderString());
        str.append("\r\n");
        str.append(this.getContentString());
        return str.toString();
    }

    public void print() {
        Debug.message(this.toString());
    }
}

