/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.awt.Font;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;

public final class ReportForeignAffairPanel
extends ReportPanel {
    public ReportForeignAffairPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportForeignAction");
        ImageLibrary lib = this.getImageLibrary();
        Font font = FontLibrary.getScaledFont("normal-bold-small");
        String stance = Messages.message(StringTemplate.key("report.foreignAffair.stance"));
        String numberOfColonies = Messages.message(StringTemplate.key("report.foreignAffair.numberOfColonies"));
        String numberOfUnits = Messages.message(StringTemplate.key("report.foreignAffair.numberOfUnits"));
        String militaryStrength = Messages.message(StringTemplate.key("report.foreignAffair.militaryStrength"));
        String navalStrength = Messages.message(StringTemplate.key("report.foreignAffair.navalStrength"));
        String goldTitle = Messages.message(StringTemplate.key("gold"));
        String continentalCongress_title = Messages.message(StringTemplate.key("report.foreignAffair.congress"));
        String tax = Messages.message(StringTemplate.key("tax"));
        String sonsOfLiberty = Messages.message(StringTemplate.key("report.foreignAffair.sonsOfLiberty"));
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("wrap 2", "[]push[]", "[align top]"));
        for (Player enemy : this.getGame().getLiveEuropeanPlayerList(new Player[0])) {
            NationSummary ns = this.igc().nationSummary(enemy);
            if (ns == null) continue;
            MigPanel enemyPanel = new MigPanel(new MigLayout("gapy 0", "[][]20[align right]0[]", ""));
            enemyPanel.setOpaque(false);
            BufferedImage coatOfArms = lib.getScaledNationImage(enemy.getNation());
            JLabel coatLabel = new JLabel(new ImageIcon(coatOfArms));
            enemyPanel.add((Component)coatLabel, "spany, aligny top");
            JLabel label = Utility.localizedLabel(enemy.getCountryLabel());
            label.setFont(font);
            enemyPanel.add((Component)label, "wrap 12");
            enemyPanel.add((Component)new JLabel(stance), "newline");
            enemyPanel.add(Utility.localizedLabel(ns.getStance().getNameKey()));
            int n = ns.getNumberOfSettlements();
            enemyPanel.add((Component)new JLabel(numberOfColonies), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getNumberOfUnits();
            enemyPanel.add((Component)new JLabel(numberOfUnits), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getMilitaryStrength();
            enemyPanel.add((Component)new JLabel(militaryStrength), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getNavalStrength();
            enemyPanel.add((Component)new JLabel(navalStrength), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getGold();
            enemyPanel.add((Component)new JLabel(goldTitle), "newline");
            enemyPanel.add(new JLabel(Integer.toString(n)));
            n = ns.getFoundingFathers();
            if (n >= 0) {
                enemyPanel.add((Component)new JLabel(continentalCongress_title), "newline 8");
                enemyPanel.add(new JLabel(Integer.toString(n)));
            }
            if ((n = ns.getTax()) >= 0) {
                enemyPanel.add((Component)new JLabel(tax), "newline");
                enemyPanel.add(new JLabel(Integer.toString(n)));
                enemyPanel.add(new JLabel("%"));
            }
            if ((n = ns.getSoL()) >= 0) {
                enemyPanel.add((Component)new JLabel(sonsOfLiberty), "newline");
                enemyPanel.add(new JLabel(Integer.toString(n)));
                enemyPanel.add(new JLabel("%"));
            }
            this.reportPanel.add(enemyPanel);
        }
        this.reportPanel.add((Component)Utility.localizedTextArea("report.foreignAffair.notice", 40), "newline 20, span 8");
        this.reportPanel.doLayout();
    }
}

