/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks.cache.impl;

import com.almworks.tracklink.codelinks.cache.impl.DataInputStream;
import com.almworks.tracklink.util.Utils;
import com.almworks.tracklink.vcslinks.VCSUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.checkin.DifferenceType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualFileRevision
implements Comparable<VirtualFileRevision> {
    private final VirtualFile myVirtualFile;
    private final String myDescription;
    private final Date myDate;
    private final DifferenceType myDifferenceType;
    private static final Date ZERO_DATE = new Date(0L);

    public VirtualFileRevision(VirtualFile virtualFile, String description, Date date, DifferenceType differenceType) {
        this.myVirtualFile = virtualFile;
        this.myDescription = description;
        this.myDate = date;
        this.myDifferenceType = differenceType;
    }

    @Deprecated
    public VirtualFileRevision(VirtualFile virtualFile, Date date, DifferenceType differenceType) {
        this(virtualFile, "", date, differenceType);
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public Date getDate() {
        return this.myDate;
    }

    @Nullable
    public String getUser() {
        return null;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public DifferenceType getDifferenceType() {
        return this.myDifferenceType;
    }

    public String toString() {
        return "VirtualFileRevision [" + this.myVirtualFile + ", " + this.myDate + ", " + this.myDifferenceType + "]";
    }

    public int hashCode() {
        return (Comparing.hashcode(this.myVirtualFile != null ? this.myVirtualFile.getUrl() : null) * 29 + Comparing.hashcode((Object)this.myDate)) * 29 + Comparing.hashcode((Object)this.myDifferenceType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VirtualFileRevision) {
            VirtualFileRevision revision = (VirtualFileRevision)obj;
            return Comparing.equal((Object)this.getVirtualFile(), (Object)revision.getVirtualFile()) && Comparing.equal((Object)this.getDate(), (Object)revision.getDate()) && Comparing.equal((Object)this.getDifferenceType(), (Object)revision.getDifferenceType());
        }
        return false;
    }

    @Override
    public int compareTo(VirtualFileRevision o) {
        int type2;
        Date date2;
        String url2;
        String url1 = this.myVirtualFile == null ? "" : this.myVirtualFile.getUrl();
        int diff = url1.compareTo(url2 = o.getVirtualFile() == null ? "" : o.getVirtualFile().getUrl());
        if (diff != 0) {
            return diff;
        }
        Date date1 = Utils.notNull(this.myDate, ZERO_DATE);
        diff = date1.compareTo(date2 = Utils.notNull(o.getDate(), ZERO_DATE));
        if (diff != 0) {
            return -diff;
        }
        int type1 = this.order(this.myDifferenceType);
        if (type1 < (type2 = this.order(o.getDifferenceType()))) {
            return -1;
        }
        if (type1 > type2) {
            return 1;
        }
        return 0;
    }

    private int order(DifferenceType type) {
        if (type == DifferenceType.INSERTED) {
            return 1;
        }
        if (type == DifferenceType.MODIFIED) {
            return 2;
        }
        if (type == DifferenceType.DELETED) {
            return 3;
        }
        return 4;
    }

    @Nullable
    public static VirtualFileRevision fromBytes(byte[] bytes, Project project) {
        DataInputStream stream = new DataInputStream(bytes);
        String fileUrl = stream.readString();
        String description = stream.readString();
        long date = stream.readLong();
        String strDiffType = stream.readString();
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        if (file == null || !file.isValid()) {
            file = VCSUtil.createMockVirtualFile(project, VirtualFileManager.extractPath((String)fileUrl), new Date(date));
        }
        if (file == null) {
            return null;
        }
        DifferenceType diffType = VirtualFileRevision.getDifferenceType(strDiffType);
        if (diffType == null) {
            return null;
        }
        return new VirtualFileRevision(file, description, new Date(date), diffType);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String fileUrl = this.myVirtualFile.isValid() ? this.myVirtualFile.getUrl() : "";
        long date = this.myDate.getTime();
        try {
            DataInputStream.writeString(stream, fileUrl);
            DataInputStream.writeString(stream, this.myDescription);
            DataInputStream.writeLong(stream, date);
            DataInputStream.writeString(stream, this.myDifferenceType.getDisplayName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    @Nullable
    private static DifferenceType getDifferenceType(String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (Comparing.strEqual((String)DifferenceType.DELETED.getDisplayName(), (String)attributeValue)) {
            return DifferenceType.DELETED;
        }
        if (Comparing.strEqual((String)DifferenceType.INSERTED.getDisplayName(), (String)attributeValue)) {
            return DifferenceType.INSERTED;
        }
        if (Comparing.strEqual((String)DifferenceType.MODIFIED.getDisplayName(), (String)attributeValue)) {
            return DifferenceType.MODIFIED;
        }
        if (Comparing.strEqual((String)DifferenceType.NOT_CHANGED.getDisplayName(), (String)attributeValue)) {
            return DifferenceType.NOT_CHANGED;
        }
        return null;
    }
}

