/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ShareAcknowledgeRequestDataJsonConverter {
    public static ShareAcknowledgeRequestData read(JsonNode _node, short _version) {
        ShareAcknowledgeRequestData.AcknowledgeTopicCollection _collection;
        ShareAcknowledgeRequestData _object = new ShareAcknowledgeRequestData();
        JsonNode _groupIdNode = _node.get("groupId");
        if (_groupIdNode == null) {
            throw new RuntimeException("ShareAcknowledgeRequestData: unable to locate field 'groupId', which is mandatory in version " + _version);
        }
        if (_groupIdNode.isNull()) {
            _object.groupId = null;
        } else {
            if (!_groupIdNode.isTextual()) {
                throw new RuntimeException("ShareAcknowledgeRequestData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.groupId = _groupIdNode.asText();
        }
        JsonNode _memberIdNode = _node.get("memberId");
        if (_memberIdNode == null) {
            throw new RuntimeException("ShareAcknowledgeRequestData: unable to locate field 'memberId', which is mandatory in version " + _version);
        }
        if (_memberIdNode.isNull()) {
            _object.memberId = null;
        } else {
            if (!_memberIdNode.isTextual()) {
                throw new RuntimeException("ShareAcknowledgeRequestData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.memberId = _memberIdNode.asText();
        }
        JsonNode _shareSessionEpochNode = _node.get("shareSessionEpoch");
        if (_shareSessionEpochNode == null) {
            throw new RuntimeException("ShareAcknowledgeRequestData: unable to locate field 'shareSessionEpoch', which is mandatory in version " + _version);
        }
        _object.shareSessionEpoch = MessageUtil.jsonNodeToInt(_shareSessionEpochNode, "ShareAcknowledgeRequestData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ShareAcknowledgeRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ShareAcknowledgeRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.topics = _collection = new ShareAcknowledgeRequestData.AcknowledgeTopicCollection(_topicsNode.size());
        for (JsonNode _element : _topicsNode) {
            _collection.add(AcknowledgeTopicJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ShareAcknowledgeRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_object.groupId == null) {
            _node.set("groupId", (JsonNode)NullNode.instance);
        } else {
            _node.set("groupId", (JsonNode)new TextNode(_object.groupId));
        }
        if (_object.memberId == null) {
            _node.set("memberId", (JsonNode)NullNode.instance);
        } else {
            _node.set("memberId", (JsonNode)new TextNode(_object.memberId));
        }
        _node.set("shareSessionEpoch", (JsonNode)new IntNode(_object.shareSessionEpoch));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ShareAcknowledgeRequestData.AcknowledgeTopic _element : _object.topics) {
            _topicsArray.add(AcknowledgeTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(ShareAcknowledgeRequestData _object, short _version) {
        return ShareAcknowledgeRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class AcknowledgeTopicJsonConverter {
        public static ShareAcknowledgeRequestData.AcknowledgeTopic read(JsonNode _node, short _version) {
            ShareAcknowledgeRequestData.AcknowledgePartitionCollection _collection;
            ShareAcknowledgeRequestData.AcknowledgeTopic _object = new ShareAcknowledgeRequestData.AcknowledgeTopic();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("AcknowledgeTopic: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("AcknowledgeTopic expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("AcknowledgeTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("AcknowledgeTopic expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.partitions = _collection = new ShareAcknowledgeRequestData.AcknowledgePartitionCollection(_partitionsNode.size());
            for (JsonNode _element : _partitionsNode) {
                _collection.add(AcknowledgePartitionJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ShareAcknowledgeRequestData.AcknowledgeTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ShareAcknowledgeRequestData.AcknowledgePartition _element : _object.partitions) {
                _partitionsArray.add(AcknowledgePartitionJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ShareAcknowledgeRequestData.AcknowledgeTopic _object, short _version) {
            return AcknowledgeTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class AcknowledgementBatchJsonConverter {
        public static ShareAcknowledgeRequestData.AcknowledgementBatch read(JsonNode _node, short _version) {
            ShareAcknowledgeRequestData.AcknowledgementBatch _object = new ShareAcknowledgeRequestData.AcknowledgementBatch();
            JsonNode _firstOffsetNode = _node.get("firstOffset");
            if (_firstOffsetNode == null) {
                throw new RuntimeException("AcknowledgementBatch: unable to locate field 'firstOffset', which is mandatory in version " + _version);
            }
            _object.firstOffset = MessageUtil.jsonNodeToLong(_firstOffsetNode, "AcknowledgementBatch");
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("AcknowledgementBatch: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            }
            _object.lastOffset = MessageUtil.jsonNodeToLong(_lastOffsetNode, "AcknowledgementBatch");
            JsonNode _acknowledgeTypesNode = _node.get("acknowledgeTypes");
            if (_acknowledgeTypesNode == null) {
                throw new RuntimeException("AcknowledgementBatch: unable to locate field 'acknowledgeTypes', which is mandatory in version " + _version);
            }
            if (!_acknowledgeTypesNode.isArray()) {
                throw new RuntimeException("AcknowledgementBatch expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Byte> _collection = new ArrayList<Byte>(_acknowledgeTypesNode.size());
            _object.acknowledgeTypes = _collection;
            for (JsonNode _element : _acknowledgeTypesNode) {
                _collection.add(MessageUtil.jsonNodeToByte(_element, "AcknowledgementBatch element"));
            }
            return _object;
        }

        public static JsonNode write(ShareAcknowledgeRequestData.AcknowledgementBatch _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("firstOffset", (JsonNode)new LongNode(_object.firstOffset));
            _node.set("lastOffset", (JsonNode)new LongNode(_object.lastOffset));
            ArrayNode _acknowledgeTypesArray = new ArrayNode(JsonNodeFactory.instance);
            for (Byte _element : _object.acknowledgeTypes) {
                _acknowledgeTypesArray.add((JsonNode)new ShortNode((short)_element.byteValue()));
            }
            _node.set("acknowledgeTypes", (JsonNode)_acknowledgeTypesArray);
            return _node;
        }

        public static JsonNode write(ShareAcknowledgeRequestData.AcknowledgementBatch _object, short _version) {
            return AcknowledgementBatchJsonConverter.write(_object, _version, true);
        }
    }

    public static class AcknowledgePartitionJsonConverter {
        public static ShareAcknowledgeRequestData.AcknowledgePartition read(JsonNode _node, short _version) {
            ShareAcknowledgeRequestData.AcknowledgePartition _object = new ShareAcknowledgeRequestData.AcknowledgePartition();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("AcknowledgePartition: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "AcknowledgePartition");
            JsonNode _acknowledgementBatchesNode = _node.get("acknowledgementBatches");
            if (_acknowledgementBatchesNode == null) {
                throw new RuntimeException("AcknowledgePartition: unable to locate field 'acknowledgementBatches', which is mandatory in version " + _version);
            }
            if (!_acknowledgementBatchesNode.isArray()) {
                throw new RuntimeException("AcknowledgePartition expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ShareAcknowledgeRequestData.AcknowledgementBatch> _collection = new ArrayList<ShareAcknowledgeRequestData.AcknowledgementBatch>(_acknowledgementBatchesNode.size());
            _object.acknowledgementBatches = _collection;
            for (JsonNode _element : _acknowledgementBatchesNode) {
                _collection.add(AcknowledgementBatchJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ShareAcknowledgeRequestData.AcknowledgePartition _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            ArrayNode _acknowledgementBatchesArray = new ArrayNode(JsonNodeFactory.instance);
            for (ShareAcknowledgeRequestData.AcknowledgementBatch _element : _object.acknowledgementBatches) {
                _acknowledgementBatchesArray.add(AcknowledgementBatchJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("acknowledgementBatches", (JsonNode)_acknowledgementBatchesArray);
            return _node;
        }

        public static JsonNode write(ShareAcknowledgeRequestData.AcknowledgePartition _object, short _version) {
            return AcknowledgePartitionJsonConverter.write(_object, _version, true);
        }
    }
}

