/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.certificates;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

class ReloadingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private volatile X509ExtendedTrustManager delegate;
    private volatile Runnable onException = () -> {};

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.delegate.checkClientTrusted(chain, authType, engine);
        }
        catch (CertificateException e) {
            this.onException.run();
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.delegate.checkClientTrusted(chain, authType, socket);
        }
        catch (CertificateException e) {
            this.onException.run();
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.delegate.checkServerTrusted(chain, authType, engine);
        }
        catch (CertificateException e) {
            this.onException.run();
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.delegate.checkServerTrusted(chain, authType, socket);
        }
        catch (CertificateException e) {
            this.onException.run();
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.delegate.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.onException.run();
            throw e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.delegate.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.onException.run();
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    public void setExceptionHandler(Runnable runnable) {
        this.onException = Objects.requireNonNullElse(runnable, () -> {});
    }

    public void reload(X509ExtendedTrustManager trustManager) {
        this.delegate = Objects.requireNonNull(trustManager);
    }
}

