/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.common.CommonStatusDetailType;
import org.keycloak.dom.saml.v1.assertion.SAML11AssertionType;
import org.keycloak.dom.saml.v1.protocol.SAML11ResponseType;
import org.keycloak.dom.saml.v1.protocol.SAML11StatusCodeType;
import org.keycloak.dom.saml.v1.protocol.SAML11StatusType;
import org.keycloak.dom.saml.v2.protocol.StatusDetailType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAML11AssertionParser;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAML11ResponseParser
implements StaxParser {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final String RESPONSE = JBossSAMLConstants.RESPONSE__PROTOCOL.get();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.RESPONSE);
        Attribute idAttr = startElement.getAttributeByName(new QName("ResponseID"));
        if (idAttr == null) {
            throw logger.parserRequiredAttribute("ResponseID");
        }
        String id = StaxParserUtil.getAttributeValue(idAttr);
        Attribute issueInstant = startElement.getAttributeByName(new QName("IssueInstant"));
        if (issueInstant == null) {
            throw logger.parserRequiredAttribute("IssueInstant");
        }
        XMLGregorianCalendar issueInstantVal = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstant));
        SAML11ResponseType response = new SAML11ResponseType(id, issueInstantVal);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getElementName(startElement);
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                Element sig = StaxParserUtil.getDOMElement(xmlEventReader);
                response.setSignature(sig);
                continue;
            }
            if (JBossSAMLConstants.ASSERTION.get().equals(elementName)) {
                SAML11AssertionParser assertionParser = new SAML11AssertionParser();
                response.add((SAML11AssertionType)assertionParser.parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.STATUS.get().equals(elementName)) {
                response.setStatus(this.parseStatus(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        return response;
    }

    protected SAML11StatusType parseStatus(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String STATUS = JBossSAMLConstants.STATUS.get();
        StaxParserUtil.validate(startElement, STATUS);
        SAML11StatusType status = new SAML11StatusType();
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            EndElement endElement;
            XMLEvent xmlEvent;
            QName startElementName = startElement.getName();
            String elementTag = startElementName.getLocalPart();
            SAML11StatusCodeType statusCode = null;
            if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                Attribute valueAttr = startElement.getAttributeByName(new QName("Value"));
                if (valueAttr != null) {
                    statusCode = new SAML11StatusCodeType(new QName(StaxParserUtil.getAttributeValue(valueAttr)));
                }
                status.setStatusCode(statusCode);
                startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                elementTag = startElement.getName().getLocalPart();
                if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                    SAML11StatusCodeType subStatusCodeType = null;
                    startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                    Attribute subValueAttr = startElement.getAttributeByName(new QName("Value"));
                    if (subValueAttr != null) {
                        subStatusCodeType = new SAML11StatusCodeType(new QName(StaxParserUtil.getAttributeValue(subValueAttr)));
                    }
                    statusCode.setStatusCode(subStatusCodeType);
                    EndElement endElement2 = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement2, JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
            }
            if (JBossSAMLConstants.STATUS_MESSAGE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                status.setStatusMessage(StaxParserUtil.getElementText(xmlEventReader));
            }
            if (JBossSAMLConstants.STATUS_DETAIL.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                StatusDetailType statusDetailType = new StatusDetailType();
                statusDetailType.addStatusDetail((Object)domElement);
                status.setStatusDetail((CommonStatusDetailType)statusDetailType);
            }
            if (!((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement) || StaxParserUtil.matches(endElement = StaxParserUtil.getNextEndElement(xmlEventReader), STATUS)) break;
            throw logger.parserUnknownEndElement(StaxParserUtil.getElementName(endElement), xmlEvent.getLocation());
        }
        return status;
    }
}

