/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.cert.CertPathBuilder;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.JsseUtils_7;

abstract class JsseUtils_8
extends JsseUtils_7 {
    JsseUtils_8() {
    }

    static void addStatusResponses(CertPathBuilder certPathBuilder, PKIXBuilderParameters pKIXBuilderParameters, Map<X509Certificate, byte[]> map) {
        if (map.isEmpty()) {
            return;
        }
        List<PKIXCertPathChecker> list = pKIXBuilderParameters.getCertPathCheckers();
        PKIXRevocationChecker pKIXRevocationChecker = JsseUtils_8.getFirstRevocationChecker(list);
        if (null != pKIXRevocationChecker) {
            Map<X509Certificate, byte[]> map2 = pKIXRevocationChecker.getOcspResponses();
            if (JsseUtils_8.putAnyAbsent(map2, map) > 0) {
                pKIXRevocationChecker.setOcspResponses(map2);
                pKIXBuilderParameters.setCertPathCheckers(list);
            }
        } else if (pKIXBuilderParameters.isRevocationEnabled()) {
            PKIXRevocationChecker pKIXRevocationChecker2 = (PKIXRevocationChecker)certPathBuilder.getRevocationChecker();
            pKIXRevocationChecker2.setOcspResponses(map);
            pKIXBuilderParameters.addCertPathChecker(pKIXRevocationChecker2);
        }
    }

    static <T> BiFunction<T, List<String>, String> exportAPSelector(BCApplicationProtocolSelector<T> bCApplicationProtocolSelector) {
        if (null == bCApplicationProtocolSelector) {
            return null;
        }
        if (bCApplicationProtocolSelector instanceof ImportAPSelector) {
            return ((ImportAPSelector)bCApplicationProtocolSelector).unwrap();
        }
        return new ExportAPSelector<T>(bCApplicationProtocolSelector);
    }

    static SNIMatcher exportSNIMatcher(BCSNIMatcher bCSNIMatcher) {
        if (null == bCSNIMatcher) {
            return null;
        }
        if (bCSNIMatcher instanceof ImportSNIMatcher) {
            return ((ImportSNIMatcher)bCSNIMatcher).unwrap();
        }
        return new ExportSNIMatcher(bCSNIMatcher);
    }

    static List<SNIMatcher> exportSNIMatchers(Collection<BCSNIMatcher> collection) {
        if (null == collection || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIMatcher> arrayList = new ArrayList<SNIMatcher>(collection.size());
        for (BCSNIMatcher bCSNIMatcher : collection) {
            arrayList.add(JsseUtils_8.exportSNIMatcher(bCSNIMatcher));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static Object exportSNIMatchersDynamic(Collection<BCSNIMatcher> collection) {
        return JsseUtils_8.exportSNIMatchers(collection);
    }

    static SNIServerName exportSNIServerName(BCSNIServerName bCSNIServerName) {
        if (null == bCSNIServerName) {
            return null;
        }
        int n = bCSNIServerName.getType();
        byte[] byArray = bCSNIServerName.getEncoded();
        switch (n) {
            case 0: {
                return new SNIHostName(byArray);
            }
        }
        return new UnknownServerName(n, byArray);
    }

    static List<SNIServerName> exportSNIServerNames(Collection<BCSNIServerName> collection) {
        if (null == collection || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIServerName> arrayList = new ArrayList<SNIServerName>(collection.size());
        for (BCSNIServerName bCSNIServerName : collection) {
            arrayList.add(JsseUtils_8.exportSNIServerName(bCSNIServerName));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static Object exportSNIServerNamesDynamic(Collection<BCSNIServerName> collection) {
        return JsseUtils_8.exportSNIServerNames(collection);
    }

    static PKIXRevocationChecker getFirstRevocationChecker(List<PKIXCertPathChecker> list) {
        for (PKIXCertPathChecker pKIXCertPathChecker : list) {
            if (!(pKIXCertPathChecker instanceof PKIXRevocationChecker)) continue;
            return (PKIXRevocationChecker)pKIXCertPathChecker;
        }
        return null;
    }

    static <T> BCApplicationProtocolSelector<T> importAPSelector(BiFunction<T, List<String>, String> biFunction) {
        if (null == biFunction) {
            return null;
        }
        if (biFunction instanceof ExportAPSelector) {
            return ((ExportAPSelector)biFunction).unwrap();
        }
        return new ImportAPSelector<T>(biFunction);
    }

    static BCSNIMatcher importSNIMatcher(SNIMatcher sNIMatcher) {
        if (null == sNIMatcher) {
            return null;
        }
        if (sNIMatcher instanceof ExportSNIMatcher) {
            return ((ExportSNIMatcher)sNIMatcher).unwrap();
        }
        return new ImportSNIMatcher(sNIMatcher);
    }

    static List<BCSNIMatcher> importSNIMatchers(Collection<SNIMatcher> collection) {
        if (null == collection || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIMatcher> arrayList = new ArrayList<BCSNIMatcher>(collection.size());
        for (SNIMatcher sNIMatcher : collection) {
            arrayList.add(JsseUtils_8.importSNIMatcher(sNIMatcher));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static List<BCSNIMatcher> importSNIMatchersDynamic(Object object) {
        return JsseUtils_8.importSNIMatchers((Collection)object);
    }

    static BCSNIServerName importSNIServerName(SNIServerName sNIServerName) {
        if (null == sNIServerName) {
            return null;
        }
        int n = sNIServerName.getType();
        byte[] byArray = sNIServerName.getEncoded();
        switch (n) {
            case 0: {
                return new BCSNIHostName(byArray);
            }
        }
        return new JsseUtils.BCUnknownServerName(n, byArray);
    }

    static List<BCSNIServerName> importSNIServerNames(Collection<SNIServerName> collection) {
        if (null == collection || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> arrayList = new ArrayList<BCSNIServerName>(collection.size());
        for (SNIServerName sNIServerName : collection) {
            arrayList.add(JsseUtils_8.importSNIServerName(sNIServerName));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static List<BCSNIServerName> importSNIServerNamesDynamic(Object object) {
        return JsseUtils_8.importSNIServerNames((Collection)object);
    }

    static <K, V> int putAnyAbsent(Map<K, V> map, Map<K, V> map2) {
        int n = 0;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (null != map.putIfAbsent(entry.getKey(), entry.getValue())) continue;
            ++n;
        }
        return n;
    }

    static class ExportAPSelector<T>
    implements BiFunction<T, List<String>, String> {
        private final BCApplicationProtocolSelector<T> selector;

        ExportAPSelector(BCApplicationProtocolSelector<T> bCApplicationProtocolSelector) {
            this.selector = bCApplicationProtocolSelector;
        }

        @Override
        public String apply(T t2, List<String> list) {
            return this.selector.select(t2, list);
        }

        BCApplicationProtocolSelector<T> unwrap() {
            return this.selector;
        }
    }

    static class ExportSNIMatcher
    extends SNIMatcher {
        private final BCSNIMatcher matcher;

        ExportSNIMatcher(BCSNIMatcher bCSNIMatcher) {
            super(bCSNIMatcher.getType());
            this.matcher = bCSNIMatcher;
        }

        @Override
        public boolean matches(SNIServerName sNIServerName) {
            return this.matcher.matches(JsseUtils_8.importSNIServerName(sNIServerName));
        }

        BCSNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class ImportAPSelector<T>
    implements BCApplicationProtocolSelector<T> {
        private final BiFunction<T, List<String>, String> selector;

        ImportAPSelector(BiFunction<T, List<String>, String> biFunction) {
            this.selector = biFunction;
        }

        @Override
        public String select(T t2, List<String> list) {
            return this.selector.apply(t2, list);
        }

        BiFunction<T, List<String>, String> unwrap() {
            return this.selector;
        }
    }

    static class ImportSNIMatcher
    extends BCSNIMatcher {
        private final SNIMatcher matcher;

        ImportSNIMatcher(SNIMatcher sNIMatcher) {
            super(sNIMatcher.getType());
            this.matcher = sNIMatcher;
        }

        @Override
        public boolean matches(BCSNIServerName bCSNIServerName) {
            return this.matcher.matches(JsseUtils_8.exportSNIServerName(bCSNIServerName));
        }

        SNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int n, byte[] byArray) {
            super(n, byArray);
        }
    }
}

