/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.resources.Resource;

public class SZAResource
extends Resource {
    private static final Logger logger = Logger.getLogger(SZAResource.class.getName());
    private static final Float DEFAULT_SCALE = Float.valueOf(1.0f);
    private final HashMap<Float, SimpleZippedAnimation> cache = new HashMap();

    public SZAResource(String cachingKey, URI resourceLocator) {
        super(cachingKey, resourceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preload() {
        SZAResource sZAResource = this;
        synchronized (sZAResource) {
            if (!this.cache.isEmpty()) {
                return;
            }
            try {
                SimpleZippedAnimation sza = new SimpleZippedAnimation(this.getResourceLocator().toURL());
                this.cache.put(DEFAULT_SCALE, sza);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not load SimpleZippedAnimation: " + this.getResourceLocator(), e);
            }
        }
    }

    public SimpleZippedAnimation getSimpleZippedAnimation() {
        return this.getSimpleZippedAnimation(DEFAULT_SCALE.floatValue());
    }

    public synchronized SimpleZippedAnimation getSimpleZippedAnimation(float scale) {
        SimpleZippedAnimation cached = this.cache.get(Float.valueOf(scale));
        if (cached != null) {
            return cached;
        }
        SimpleZippedAnimation sza = this.cache.get(DEFAULT_SCALE).createScaledVersion(scale);
        this.cache.put(Float.valueOf(scale), sza);
        return sza;
    }
}

